/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransform;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.persistence.DataframeIndex;
import org.elasticsearch.xpack.dataframe.transforms.SourceDestValidator;
import org.elasticsearch.xpack.dataframe.transforms.pivot.Pivot;

public class TransportStartDataFrameTransformAction
extends TransportMasterNodeAction<StartDataFrameTransformAction.Request, StartDataFrameTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStartDataFrameTransformAction.class);
    private final XPackLicenseState licenseState;
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final DataFrameAuditor auditor;

    @Inject
    public TransportStartDataFrameTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, XPackLicenseState licenseState, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, PersistentTasksService persistentTasksService, Client client, DataFrameAuditor auditor) {
        super("cluster:admin/data_frame/start", transportService, clusterService, threadPool, actionFilters, StartDataFrameTransformAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.auditor = auditor;
    }

    protected String executor() {
        return "same";
    }

    protected StartDataFrameTransformAction.Response read(StreamInput in) throws IOException {
        return new StartDataFrameTransformAction.Response(in);
    }

    protected void masterOperation(StartDataFrameTransformAction.Request request, ClusterState state, ActionListener<StartDataFrameTransformAction.Response> listener) throws Exception {
        if (!this.licenseState.isDataFrameAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"data_frame"));
            return;
        }
        AtomicReference transformTaskHolder = new AtomicReference();
        ActionListener newPersistentTaskActionListener = ActionListener.wrap(task -> {
            DataFrameTransform transformTask = (DataFrameTransform)transformTaskHolder.get();
            assert (transformTask != null);
            this.waitForDataFrameTaskStarted(task.getId(), transformTask, request.timeout(), (ActionListener<Boolean>)ActionListener.wrap(taskStarted -> listener.onResponse((Object)new StartDataFrameTransformAction.Response(true)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createOrGetIndexListener = ActionListener.wrap(unused -> {
            DataFrameTransform transformTask = (DataFrameTransform)transformTaskHolder.get();
            assert (transformTask != null);
            PersistentTasksCustomMetaData.PersistentTask<DataFrameTransform> existingTask = TransportStartDataFrameTransformAction.getExistingTask(transformTask.getId(), state);
            if (existingTask == null) {
                this.persistentTasksService.sendStartRequest(transformTask.getId(), "data_frame/transforms", (PersistentTaskParams)transformTask, newPersistentTaskActionListener);
            } else {
                DataFrameTransformState transformState = (DataFrameTransformState)existingTask.getState();
                if (transformState.getTaskState() == DataFrameTransformTaskState.FAILED && !request.isForce()) {
                    listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to start data frame transform [" + request.getId() + "] as it is in a failed state with failure: [" + transformState.getReason() + "]. Use force start to restart data frame transform once error is resolved.", RestStatus.CONFLICT, new Object[0])));
                } else if (transformState.getTaskState() != DataFrameTransformTaskState.STOPPED && transformState.getTaskState() != DataFrameTransformTaskState.FAILED) {
                    listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to start data frame transform [" + request.getId() + "] as it is in state [" + transformState.getTaskState() + "]", RestStatus.CONFLICT, new Object[0])));
                } else {
                    if (!existingTask.isAssigned()) {
                        String assignmentExplanation = "unknown reason";
                        if (existingTask.getAssignment() != null) {
                            assignmentExplanation = existingTask.getAssignment().getExplanation();
                        }
                        listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to start data frame transform [" + request.getId() + "] as it is not assigned to a node, explanation: " + assignmentExplanation, RestStatus.CONFLICT, new Object[0])));
                        return;
                    }
                    ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"data_frame", (ActionType)StartDataFrameTransformTaskAction.INSTANCE, (ActionRequest)new StartDataFrameTransformTaskAction.Request(request.getId(), request.isForce()), (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)new StartDataFrameTransformAction.Response(true)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getTransformListener = ActionListener.wrap(config -> {
            if (!config.isValid()) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException(DataFrameMessages.getMessage((String)"Data frame transform configuration is invalid [{0}]", (Object[])new Object[]{request.getId()}), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            SourceDestValidator.validate(config, this.clusterService.state(), this.indexNameExpressionResolver, false);
            transformTaskHolder.set(TransportStartDataFrameTransformAction.createDataFrameTransform(config.getId(), config.getVersion(), config.getFrequency()));
            String destinationIndex = config.getDestination().getIndex();
            String[] dest = this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), new String[]{destinationIndex});
            if (dest.length == 0) {
                this.auditor.info(request.getId(), "Creating destination index [" + destinationIndex + "] with deduced mappings.");
                this.createDestinationIndex((DataFrameTransformConfig)config, (ActionListener<Void>)createOrGetIndexListener);
            } else {
                this.auditor.info(request.getId(), "Using existing destination index [" + destinationIndex + "].");
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"data_frame", (ActionRequest)((IndicesStatsRequest)this.client.admin().indices().prepareStats(dest).clear().setDocs(true).request()), (ActionListener)ActionListener.wrap(r -> {
                    long docTotal = r.getTotal().docs.getCount();
                    if (docTotal > 0L) {
                        this.auditor.warning(request.getId(), "Non-empty destination index [" + destinationIndex + "]. Contains [" + docTotal + "] total documents.");
                    }
                    createOrGetIndexListener.onResponse(null);
                }, e -> {
                    String msg = "Unable to determine destination index stats, error: " + e.getMessage();
                    logger.error(msg, (Throwable)e);
                    this.auditor.warning(request.getId(), msg);
                    createOrGetIndexListener.onResponse(null);
                }), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).stats(arg_0, arg_1));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.dataFrameTransformsConfigManager.getTransformConfiguration(request.getId(), (ActionListener<DataFrameTransformConfig>)getTransformListener);
    }

    private void createDestinationIndex(DataFrameTransformConfig config, ActionListener<Void> listener) {
        Pivot pivot = new Pivot(config.getPivotConfig());
        ActionListener deduceMappingsListener = ActionListener.wrap(mappings -> DataframeIndex.createDestinationIndex(this.client, Clock.systemUTC(), config, mappings, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), deduceTargetMappingsException -> listener.onFailure((Exception)new RuntimeException("Failed to deduce dest mappings", (Throwable)deduceTargetMappingsException)));
        pivot.deduceMappings(this.client, config.getSource(), (ActionListener<Map<String, String>>)deduceMappingsListener);
    }

    protected ClusterBlockException checkBlock(StartDataFrameTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static DataFrameTransform createDataFrameTransform(String transformId, Version transformVersion, TimeValue frequency) {
        return new DataFrameTransform(transformId, transformVersion, frequency);
    }

    private static PersistentTasksCustomMetaData.PersistentTask<DataFrameTransform> getExistingTask(String id, ClusterState state) {
        PersistentTasksCustomMetaData pTasksMeta = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (pTasksMeta == null) {
            return null;
        }
        Collection existingTask = pTasksMeta.findTasks("data_frame/transforms", t -> t.getId().equals(id));
        if (existingTask.isEmpty()) {
            return null;
        }
        assert (existingTask.size() == 1);
        PersistentTasksCustomMetaData.PersistentTask pTask = (PersistentTasksCustomMetaData.PersistentTask)existingTask.iterator().next();
        if (pTask.getParams() instanceof DataFrameTransform) {
            return pTask;
        }
        throw new ElasticsearchStatusException("Found data frame transform persistent task [" + id + "] with incorrect params", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    private void cancelDataFrameTask(String taskId, final String dataFrameId, final Exception exception, final Consumer<Exception> onFailure) {
        this.persistentTasksService.sendRemoveRequest(taskId, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                onFailure.accept(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + dataFrameId + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                onFailure.accept(exception);
            }
        });
    }

    private void waitForDataFrameTaskStarted(final String taskId, final DataFrameTransform params, TimeValue timeout, final ActionListener<Boolean> listener) {
        final DataFramePredicate predicate = new DataFramePredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<DataFrameTransform>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<DataFrameTransform> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDataFrameTransformAction.this.cancelDataFrameTask(taskId, params.getId(), predicate.exception, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                } else {
                    listener.onResponse((Object)true);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Starting dataframe [" + params.getId() + "] timed out after [" + timeout + "]", new Object[0])));
            }
        });
    }

    private class DataFramePredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile Exception exception;

        private DataFramePredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start dataframe, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            return assignment != null && assignment.isAssigned() && this.isNotStopped(persistentTask);
        }

        private boolean isNotStopped(PersistentTasksCustomMetaData.PersistentTask<?> task) {
            DataFrameTransformState state = (DataFrameTransformState)task.getState();
            return state != null && !state.getTaskState().equals((Object)DataFrameTransformTaskState.STOPPED);
        }
    }
}

