/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsStatsAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformStats;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformStoredDoc;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.xpack.core.dataframe.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.dataframe.action.DataFrameNodes;
import org.elasticsearch.xpack.dataframe.checkpoint.DataFrameTransformsCheckpointService;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformTask;

public class TransportGetDataFrameTransformsStatsAction
extends TransportTasksAction<DataFrameTransformTask, GetDataFrameTransformsStatsAction.Request, GetDataFrameTransformsStatsAction.Response, GetDataFrameTransformsStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDataFrameTransformsStatsAction.class);
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final DataFrameTransformsCheckpointService transformsCheckpointService;

    @Inject
    public TransportGetDataFrameTransformsStatsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, DataFrameTransformsCheckpointService transformsCheckpointService) {
        super("cluster:monitor/data_frame/stats/get", clusterService, transportService, actionFilters, GetDataFrameTransformsStatsAction.Request::new, GetDataFrameTransformsStatsAction.Response::new, GetDataFrameTransformsStatsAction.Response::new, "same");
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.transformsCheckpointService = transformsCheckpointService;
    }

    protected GetDataFrameTransformsStatsAction.Response newResponse(GetDataFrameTransformsStatsAction.Request request, List<GetDataFrameTransformsStatsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        List responses = tasks.stream().flatMap(r -> r.getTransformsStats().stream()).sorted(Comparator.comparing(DataFrameTransformStats::getId)).collect(Collectors.toList());
        ArrayList<FailedNodeException> allFailedNodeExceptions = new ArrayList<FailedNodeException>(failedNodeExceptions);
        allFailedNodeExceptions.addAll(tasks.stream().flatMap(r -> r.getNodeFailures().stream()).collect(Collectors.toList()));
        return new GetDataFrameTransformsStatsAction.Response(responses, (long)responses.size(), taskOperationFailures, allFailedNodeExceptions);
    }

    protected void taskOperation(GetDataFrameTransformsStatsAction.Request request, DataFrameTransformTask task, ActionListener<GetDataFrameTransformsStatsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        String nodeId = state.nodes().getLocalNode().getId();
        if (!task.isCancelled()) {
            DataFrameTransformState transformState = task.getState();
            task.getCheckpointingInfo(this.transformsCheckpointService, (ActionListener<DataFrameTransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> listener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(Collections.singletonList(new DataFrameTransformStats(task.getTransformId(), DataFrameTransformStats.State.fromComponents((DataFrameTransformTaskState)transformState.getTaskState(), (IndexerState)transformState.getIndexerState()), transformState.getReason(), null, task.getStats(), checkpointingInfo)), 1L)), e -> {
                logger.warn("Failed to retrieve checkpointing info for transform [" + task.getTransformId() + "]", (Throwable)e);
                listener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(Collections.singletonList(new DataFrameTransformStats(task.getTransformId(), DataFrameTransformStats.State.fromComponents((DataFrameTransformTaskState)transformState.getTaskState(), (IndexerState)transformState.getIndexerState()), transformState.getReason(), null, task.getStats(), DataFrameTransformCheckpointingInfo.EMPTY)), 1L, Collections.emptyList(), Collections.singletonList(new FailedNodeException(nodeId, "Failed to retrieve checkpointing info", (Throwable)e))));
            }));
        } else {
            listener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(Collections.emptyList(), 0L));
        }
    }

    protected void doExecute(Task task, GetDataFrameTransformsStatsAction.Request request, ActionListener<GetDataFrameTransformsStatsAction.Response> finalListener) {
        this.dataFrameTransformsConfigManager.expandTransformIds(request.getId(), request.getPageParams(), request.isAllowNoMatch(), (ActionListener<Tuple<Long, List<String>>>)ActionListener.wrap(hitsAndIds -> {
            request.setExpandedIds((List)hitsAndIds.v2());
            ClusterState state = this.clusterService.state();
            request.setNodes(DataFrameNodes.dataFrameTaskNodes((List)hitsAndIds.v2(), state));
            super.doExecute(task, (BaseTasksRequest)request, ActionListener.wrap(response -> {
                PersistentTasksCustomMetaData tasksInProgress = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
                if (tasksInProgress != null) {
                    response.getTransformsStats().forEach(dtsasi -> TransportGetDataFrameTransformsStatsAction.setNodeAttributes(dtsasi, tasksInProgress, state));
                }
                this.collectStatsForTransformsWithoutTasks(request, (GetDataFrameTransformsStatsAction.Response)response, (ActionListener<GetDataFrameTransformsStatsAction.Response>)ActionListener.wrap(finalResponse -> finalListener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(finalResponse.getTransformsStats(), ((Long)hitsAndIds.v1()).longValue(), finalResponse.getTaskFailures(), finalResponse.getNodeFailures())), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
            }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof ResourceNotFoundException) {
                finalListener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(Collections.emptyList(), 0L));
            } else {
                finalListener.onFailure(e);
            }
        }));
    }

    private static void setNodeAttributes(DataFrameTransformStats dataFrameTransformStats, PersistentTasksCustomMetaData persistentTasksCustomMetaData, ClusterState state) {
        PersistentTasksCustomMetaData.PersistentTask pTask = persistentTasksCustomMetaData.getTask(dataFrameTransformStats.getId());
        if (pTask != null) {
            dataFrameTransformStats.setNode(NodeAttributes.fromDiscoveryNode((DiscoveryNode)state.nodes().get(pTask.getExecutorNode())));
        }
    }

    private void collectStatsForTransformsWithoutTasks(GetDataFrameTransformsStatsAction.Request request, GetDataFrameTransformsStatsAction.Response response, ActionListener<GetDataFrameTransformsStatsAction.Response> listener) {
        if (request.getExpandedIds().size() == response.getTransformsStats().size()) {
            listener.onResponse((Object)response);
            return;
        }
        HashSet<String> transformsWithoutTasks = new HashSet<String>(request.getExpandedIds());
        transformsWithoutTasks.removeAll(response.getTransformsStats().stream().map(DataFrameTransformStats::getId).collect(Collectors.toList()));
        assert (transformsWithoutTasks.size() <= 1000);
        ActionListener searchStatsListener = ActionListener.wrap(statsForTransformsWithoutTasks -> {
            List allStateAndStats = response.getTransformsStats();
            this.addCheckpointingInfoForTransformsWithoutTasks(allStateAndStats, (List<DataFrameTransformStoredDoc>)statsForTransformsWithoutTasks, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                transformsWithoutTasks.removeAll(statsForTransformsWithoutTasks.stream().map(DataFrameTransformStoredDoc::getId).collect(Collectors.toSet()));
                transformsWithoutTasks.forEach(transformId -> allStateAndStats.add(DataFrameTransformStats.initialStats((String)transformId)));
                allStateAndStats.sort(Comparator.comparing(DataFrameTransformStats::getId));
                listener.onResponse((Object)new GetDataFrameTransformsStatsAction.Response(allStateAndStats, (long)allStateAndStats.size(), response.getTaskFailures(), response.getNodeFailures()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)response);
            } else {
                listener.onFailure(e);
            }
        });
        this.dataFrameTransformsConfigManager.getTransformStoredDoc(transformsWithoutTasks, (ActionListener<List<DataFrameTransformStoredDoc>>)searchStatsListener);
    }

    private void populateSingleStoppedTransformStat(DataFrameTransformStoredDoc transform, ActionListener<DataFrameTransformCheckpointingInfo> listener) {
        this.transformsCheckpointService.getCheckpointingInfo(transform.getId(), transform.getTransformState().getCheckpoint(), transform.getTransformState().getPosition(), transform.getTransformState().getProgress(), (ActionListener<DataFrameTransformCheckpointingInfo>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            logger.warn("Failed to retrieve checkpointing info for transform [" + transform.getId() + "]", (Throwable)e);
            listener.onResponse((Object)DataFrameTransformCheckpointingInfo.EMPTY);
        }));
    }

    private void addCheckpointingInfoForTransformsWithoutTasks(List<DataFrameTransformStats> allStateAndStats, List<DataFrameTransformStoredDoc> statsForTransformsWithoutTasks, ActionListener<Void> listener) {
        if (statsForTransformsWithoutTasks.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        AtomicInteger numberRemaining = new AtomicInteger(statsForTransformsWithoutTasks.size());
        AtomicBoolean isExceptionReported = new AtomicBoolean(false);
        statsForTransformsWithoutTasks.forEach(stat -> this.populateSingleStoppedTransformStat((DataFrameTransformStoredDoc)stat, (ActionListener<DataFrameTransformCheckpointingInfo>)ActionListener.wrap(checkpointingInfo -> {
            List list = allStateAndStats;
            synchronized (list) {
                allStateAndStats.add(new DataFrameTransformStats(stat.getId(), DataFrameTransformStats.State.STOPPED, null, null, stat.getTransformStats(), checkpointingInfo));
            }
            if (numberRemaining.decrementAndGet() == 0) {
                listener.onResponse(null);
            }
        }, e -> {
            if (isExceptionReported.compareAndSet(false, true)) {
                listener.onFailure(e);
            }
        })));
    }
}

