/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;

public class TransportGetDataFrameTransformsAction
extends AbstractTransportGetResourcesAction<DataFrameTransformConfig, GetDataFrameTransformsAction.Request, GetDataFrameTransformsAction.Response> {
    @Inject
    public TransportGetDataFrameTransformsAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/data_frame/get", transportService, actionFilters, GetDataFrameTransformsAction.Request::new, client, xContentRegistry);
    }

    protected void doExecute(Task task, GetDataFrameTransformsAction.Request request, ActionListener<GetDataFrameTransformsAction.Response> listener) {
        this.searchResources((AbstractGetResourcesRequest)request, ActionListener.wrap(r -> listener.onResponse((Object)new GetDataFrameTransformsAction.Response(r.results(), r.count())), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ParseField getResultsField() {
        return DataFrameField.TRANSFORMS;
    }

    protected String[] getIndices() {
        return new String[]{".data-frame-internal-*"};
    }

    protected DataFrameTransformConfig parse(XContentParser parser) {
        return DataFrameTransformConfig.fromXContent((XContentParser)parser, null, (boolean)true);
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return new ResourceNotFoundException(DataFrameMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{resourceId}), new Object[0]);
    }

    protected String executionOrigin() {
        return "data_frame";
    }

    protected String extractIdFromResource(DataFrameTransformConfig transformConfig) {
        return transformConfig.getId();
    }

    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)DataFrameField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config");
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.sort("_index", SortOrder.DESC);
    }
}

