/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.internal;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat128 {
    private static final long M = 0xFFFFFFFFL;

    public static int add(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        nArray3[0] = (int)(l += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l >>>= 32);
    }

    public static int addBothTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        nArray3[0] = (int)(l += ((long)nArray[0] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)nArray3[0] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) + ((long)nArray2[1] & 0xFFFFFFFFL) + ((long)nArray3[1] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) + ((long)nArray2[2] & 0xFFFFFFFFL) + ((long)nArray3[2] & 0xFFFFFFFFL));
        l >>>= 32;
        nArray3[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) + ((long)nArray2[3] & 0xFFFFFFFFL) + ((long)nArray3[3] & 0xFFFFFFFFL));
        return (int)(l >>>= 32);
    }

    public static int[] create() {
        return new int[4];
    }

    public static long[] create64() {
        return new long[2];
    }

    public static int[] createExt() {
        return new int[8];
    }

    public static long[] createExt64() {
        return new long[4];
    }

    public static boolean eq(int[] nArray, int[] nArray2) {
        for (int i = 3; i >= 0; --i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int i = 1; i >= 0; --i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat128.create();
        int n = 0;
        while (bigInteger.signum() != 0) {
            nArray[n++] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 128) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat128.create64();
        int n = 0;
        while (bigInteger.signum() != 0) {
            lArray[n++] = bigInteger.longValue();
            bigInteger = bigInteger.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] nArray, int n) {
        if (n == 0) {
            return nArray[0] & 1;
        }
        int n2 = n >> 5;
        if (n2 < 0 || n2 >= 4) {
            return 0;
        }
        int n3 = n & 0x1F;
        return nArray[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] nArray, int[] nArray2) {
        for (int i = 3; i >= 0; --i) {
            int n = nArray[i] ^ Integer.MIN_VALUE;
            int n2 = nArray2[i] ^ Integer.MIN_VALUE;
            if (n < n2) {
                return false;
            }
            if (n <= n2) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] nArray) {
        if (nArray[0] != 1) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int i = 1; i < 2; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] nArray) {
        for (int i = 0; i < 4; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int i = 0; i < 2; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)nArray2[0] & 0xFFFFFFFFL;
        long l2 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l5 = 0L;
        long l6 = (long)nArray[0] & 0xFFFFFFFFL;
        nArray3[0] = (int)(l5 += l6 * l);
        l5 >>>= 32;
        nArray3[1] = (int)(l5 += l6 * l2);
        l5 >>>= 32;
        nArray3[2] = (int)(l5 += l6 * l3);
        l5 >>>= 32;
        nArray3[3] = (int)(l5 += l6 * l4);
        nArray3[4] = (int)(l5 >>>= 32);
        for (int i = 1; i < 4; ++i) {
            long l7 = 0L;
            long l8 = (long)nArray[i] & 0xFFFFFFFFL;
            nArray3[i + 0] = (int)(l7 += l8 * l + ((long)nArray3[i + 0] & 0xFFFFFFFFL));
            l7 >>>= 32;
            nArray3[i + 1] = (int)(l7 += l8 * l2 + ((long)nArray3[i + 1] & 0xFFFFFFFFL));
            l7 >>>= 32;
            nArray3[i + 2] = (int)(l7 += l8 * l3 + ((long)nArray3[i + 2] & 0xFFFFFFFFL));
            l7 >>>= 32;
            nArray3[i + 3] = (int)(l7 += l8 * l4 + ((long)nArray3[i + 3] & 0xFFFFFFFFL));
            nArray3[i + 4] = (int)(l7 >>>= 32);
        }
    }

    public static int mulAddTo(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = (long)nArray2[0] & 0xFFFFFFFFL;
        long l2 = (long)nArray2[1] & 0xFFFFFFFFL;
        long l3 = (long)nArray2[2] & 0xFFFFFFFFL;
        long l4 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l5 = 0L;
        for (int i = 0; i < 4; ++i) {
            long l6 = 0L;
            long l7 = (long)nArray[i] & 0xFFFFFFFFL;
            nArray3[i + 0] = (int)(l6 += l7 * l + ((long)nArray3[i + 0] & 0xFFFFFFFFL));
            l6 >>>= 32;
            nArray3[i + 1] = (int)(l6 += l7 * l2 + ((long)nArray3[i + 1] & 0xFFFFFFFFL));
            l6 >>>= 32;
            nArray3[i + 2] = (int)(l6 += l7 * l3 + ((long)nArray3[i + 2] & 0xFFFFFFFFL));
            l6 >>>= 32;
            nArray3[i + 3] = (int)(l6 += l7 * l4 + ((long)nArray3[i + 3] & 0xFFFFFFFFL));
            l6 >>>= 32;
            nArray3[i + 4] = (int)(l6 += l5 + ((long)nArray3[i + 4] & 0xFFFFFFFFL));
            l5 = l6 >>> 32;
        }
        return (int)l5;
    }

    public static void square(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        long l3 = (long)nArray[0] & 0xFFFFFFFFL;
        int n = 0;
        int n2 = 3;
        int n3 = 8;
        do {
            l2 = (long)nArray[n2--] & 0xFFFFFFFFL;
            l = l2 * l2;
            nArray2[--n3] = n << 31 | (int)(l >>> 33);
            nArray2[--n3] = (int)(l >>> 1);
            n = (int)l;
        } while (n2 > 0);
        l2 = l3 * l3;
        long l4 = (long)(n << 31) & 0xFFFFFFFFL | l2 >>> 33;
        nArray2[0] = (int)l2;
        n = (int)(l2 >>> 32) & 1;
        long l5 = (long)nArray[1] & 0xFFFFFFFFL;
        l2 = (long)nArray2[2] & 0xFFFFFFFFL;
        int n4 = (int)(l4 += l5 * l3);
        nArray2[1] = n4 << 1 | n;
        n = n4 >>> 31;
        l2 += l4 >>> 32;
        l = (long)nArray[2] & 0xFFFFFFFFL;
        long l6 = (long)nArray2[3] & 0xFFFFFFFFL;
        long l7 = (long)nArray2[4] & 0xFFFFFFFFL;
        n4 = (int)(l2 += l * l3);
        nArray2[2] = n4 << 1 | n;
        n = n4 >>> 31;
        l6 &= 0xFFFFFFFFL;
        long l8 = (long)nArray[3] & 0xFFFFFFFFL;
        long l9 = ((long)nArray2[5] & 0xFFFFFFFFL) + ((l7 += (l6 += (l2 >>> 32) + l * l5) >>> 32) >>> 32);
        l7 &= 0xFFFFFFFFL;
        long l10 = ((long)nArray2[6] & 0xFFFFFFFFL) + (l9 >>> 32);
        l9 &= 0xFFFFFFFFL;
        n4 = (int)(l6 += l8 * l3);
        nArray2[3] = n4 << 1 | n;
        n = n4 >>> 31;
        l10 += (l9 += ((l7 += (l6 >>> 32) + l8 * l5) >>> 32) + l8 * l) >>> 32;
        n4 = (int)l7;
        nArray2[4] = n4 << 1 | n;
        n = n4 >>> 31;
        n4 = (int)(l9 &= 0xFFFFFFFFL);
        nArray2[5] = n4 << 1 | n;
        n = n4 >>> 31;
        n4 = (int)l10;
        nArray2[6] = n4 << 1 | n;
        n = n4 >>> 31;
        n4 = nArray2[7] + (int)(l10 >>> 32);
        nArray2[7] = n4 << 1 | n;
    }

    public static int sub(int[] nArray, int[] nArray2, int[] nArray3) {
        long l = 0L;
        nArray3[0] = (int)(l += ((long)nArray[0] & 0xFFFFFFFFL) - ((long)nArray2[0] & 0xFFFFFFFFL));
        l >>= 32;
        nArray3[1] = (int)(l += ((long)nArray[1] & 0xFFFFFFFFL) - ((long)nArray2[1] & 0xFFFFFFFFL));
        l >>= 32;
        nArray3[2] = (int)(l += ((long)nArray[2] & 0xFFFFFFFFL) - ((long)nArray2[2] & 0xFFFFFFFFL));
        l >>= 32;
        nArray3[3] = (int)(l += ((long)nArray[3] & 0xFFFFFFFFL) - ((long)nArray2[3] & 0xFFFFFFFFL));
        return (int)(l >>= 32);
    }

    public static int subFrom(int[] nArray, int[] nArray2) {
        long l = 0L;
        nArray2[0] = (int)(l += ((long)nArray2[0] & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL));
        l >>= 32;
        nArray2[1] = (int)(l += ((long)nArray2[1] & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL));
        l >>= 32;
        nArray2[2] = (int)(l += ((long)nArray2[2] & 0xFFFFFFFFL) - ((long)nArray[2] & 0xFFFFFFFFL));
        l >>= 32;
        nArray2[3] = (int)(l += ((long)nArray2[3] & 0xFFFFFFFFL) - ((long)nArray[3] & 0xFFFFFFFFL));
        return (int)(l >>= 32);
    }

    public static BigInteger toBigInteger(int[] nArray) {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int n = nArray[i];
            if (n == 0) continue;
            Pack.intToBigEndian(n, byArray, 3 - i << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 2; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            Pack.longToBigEndian(l, byArray, 1 - i << 3);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] nArray) {
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
    }
}

