/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class ShapeIndexer
implements AbstractGeometryFieldMapper.Indexer<Geometry, Geometry> {
    private final String name;

    public ShapeIndexer(String name) {
        this.name = name;
    }

    public Geometry prepareForIndexing(Geometry geometry) {
        return geometry;
    }

    public Class<Geometry> processedClass() {
        return Geometry.class;
    }

    public List<IndexableField> indexShape(ParseContext context, Geometry shape) {
        LuceneGeometryVisitor visitor = new LuceneGeometryVisitor(this.name);
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields;
    }

    public static XYPolygon toLucenePolygon(Polygon polygon) {
        float[][] vertices;
        LinearRing ring;
        XYPolygon[] holes = new XYPolygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            ring = polygon.getHole(i);
            vertices = ShapeIndexer.lineToFloatArray(ring.getX(), ring.getY());
            holes[i] = new XYPolygon(vertices[0], vertices[1], new XYPolygon[0]);
        }
        ring = polygon.getPolygon();
        vertices = ShapeIndexer.lineToFloatArray(ring.getX(), ring.getY());
        return new XYPolygon(vertices[0], vertices[1], holes);
    }

    private static float[][] lineToFloatArray(double[] x, double[] y) {
        float[][] result = new float[2][x.length];
        for (int i = 0; i < x.length; ++i) {
            result[0][i] = (float)x[i];
            result[1][i] = (float)y[i];
        }
        return result;
    }

    private class LuceneGeometryVisitor
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private String name;

        private LuceneGeometryVisitor(String name) {
            this.name = name;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            float[][] vertices = ShapeIndexer.lineToFloatArray(line.getX(), line.getY());
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYLine)new XYLine(vertices[0], vertices[1])));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (float)((float)point.getX()), (float)((float)point.getY())));
            return null;
        }

        public Void visit(Polygon polygon) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)ShapeIndexer.toLucenePolygon(polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            XYPolygon p = new XYPolygon(new float[]{(float)r.getMinX(), (float)r.getMaxX(), (float)r.getMaxX(), (float)r.getMinX(), (float)r.getMinX()}, new float[]{(float)r.getMinY(), (float)r.getMinY(), (float)r.getMaxY(), (float)r.getMaxY(), (float)r.getMinY()}, new XYPolygon[0]);
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)p));
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

