/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.spatial.SpatialFeatureSet;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeFieldMapper;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryBuilder;
import org.elasticsearch.xpack.spatial.ingest.CircleProcessor;

public class SpatialPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin,
IngestPlugin {
    public SpatialPlugin(Settings settings) {
    }

    public Collection<Module> createGuiceModules() {
        return Collections.singletonList(b -> XPackPlugin.bindFeatureSet((Binder)b, SpatialFeatureSet.class));
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, ShapeFieldMapper.TypeParser> mappers = new LinkedHashMap<String, ShapeFieldMapper.TypeParser>();
        mappers.put("shape", new ShapeFieldMapper.TypeParser());
        return Collections.unmodifiableMap(mappers);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("shape", ShapeQueryBuilder::new, ShapeQueryBuilder::fromXContent));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Collections.singletonMap("circle", new CircleProcessor.Factory());
    }
}

