/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.spatial.SpatialFeatureSetUsage;

public class SpatialFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;

    @Inject
    public SpatialFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }

    public String name() {
        return "spatial";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isSpatialAllowed();
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new SpatialFeatureSetUsage(this.available(), this.enabled()));
    }
}

