/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterAwareClient;
import org.elasticsearch.transport.RemoteClusterConnection;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public final class RemoteClusterService
extends RemoteClusterAware
implements Closeable {
    private static final Logger logger = LogManager.getLogger(RemoteClusterService.class);
    private static final ActionListener<Void> noopListener = ActionListener.wrap(x -> {}, x -> {});
    public static final Setting<Integer> SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER;
    public static final Setting<Integer> REMOTE_CONNECTIONS_PER_CLUSTER;
    public static final Setting<TimeValue> SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING;
    public static final Setting<TimeValue> REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING;
    public static final Setting<String> SEARCH_REMOTE_NODE_ATTRIBUTE;
    public static final Setting<String> REMOTE_NODE_ATTRIBUTE;
    public static final Setting<Boolean> SEARCH_ENABLE_REMOTE_CLUSTERS;
    public static final Setting<Boolean> ENABLE_REMOTE_CLUSTERS;
    public static final Setting.AffixSetting<Boolean> SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE;
    public static final SettingUpgrader<Boolean> SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE_UPGRADER;
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_SKIP_UNAVAILABLE;
    public static final Setting.AffixSetting<TimeValue> REMOTE_CLUSTER_PING_SCHEDULE;
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_COMPRESS;
    private static final Predicate<DiscoveryNode> DEFAULT_NODE_PREDICATE;
    private final TransportService transportService;
    private final int numRemoteConnections;
    private volatile Map<String, RemoteClusterConnection> remoteClusters = Collections.emptyMap();
    private volatile Map<String, ConnectionProfile> remoteClusterConnectionProfiles = Collections.emptyMap();

    RemoteClusterService(Settings settings, TransportService transportService) {
        super(settings);
        this.transportService = transportService;
        this.numRemoteConnections = REMOTE_CONNECTIONS_PER_CLUSTER.get(settings);
    }

    private synchronized void updateRemoteClusters(Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> seeds, ActionListener<Void> connectionListener) {
        if (seeds.containsKey("")) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        HashMap<String, RemoteClusterConnection> remoteClusters = new HashMap<String, RemoteClusterConnection>();
        if (seeds.isEmpty()) {
            connectionListener.onResponse(null);
        } else {
            CountDown countDown = new CountDown(seeds.size());
            remoteClusters.putAll(this.remoteClusters);
            for (Map.Entry<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> entry : seeds.entrySet()) {
                List<Tuple<String, Supplier<DiscoveryNode>>> seedList = entry.getValue().v2();
                String proxyAddress = entry.getValue().v1();
                String clusterAlias = entry.getKey();
                RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
                ConnectionProfile connectionProfile = this.remoteClusterConnectionProfiles.get(clusterAlias);
                if (seedList.isEmpty()) {
                    try {
                        IOUtils.close(remote);
                    }
                    catch (IOException e) {
                        logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
                    }
                    remoteClusters.remove(clusterAlias);
                    continue;
                }
                if (remote == null) {
                    remote = new RemoteClusterConnection(this.settings, clusterAlias, seedList, this.transportService, this.numRemoteConnections, RemoteClusterService.getNodePredicate(this.settings), proxyAddress, connectionProfile);
                    remoteClusters.put(clusterAlias, remote);
                } else if (this.connectionProfileChanged(remote.getConnectionManager().getConnectionProfile(), connectionProfile) || this.seedsChanged(remote.getSeedNodes(), seedList)) {
                    try {
                        IOUtils.close(remote);
                    }
                    catch (IOException e) {
                        logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
                    }
                    remoteClusters.remove(clusterAlias);
                    remote = new RemoteClusterConnection(this.settings, clusterAlias, seedList, this.transportService, this.numRemoteConnections, RemoteClusterService.getNodePredicate(this.settings), proxyAddress, connectionProfile);
                    remoteClusters.put(clusterAlias, remote);
                }
                RemoteClusterConnection finalRemote = remote;
                remote.updateSeedNodes(proxyAddress, seedList, ActionListener.wrap(response -> {
                    if (countDown.countDown()) {
                        connectionListener.onResponse((Void)response);
                    }
                }, exception -> {
                    if (countDown.fastForward()) {
                        connectionListener.onFailure((Exception)exception);
                    }
                    if (!finalRemote.isClosed()) {
                        logger.warn("failed to update seed list for cluster: " + clusterAlias, (Throwable)exception);
                    }
                }));
            }
        }
        this.remoteClusters = Collections.unmodifiableMap(remoteClusters);
    }

    static Predicate<DiscoveryNode> getNodePredicate(Settings settings) {
        if (REMOTE_NODE_ATTRIBUTE.exists(settings)) {
            String attribute = REMOTE_NODE_ATTRIBUTE.get(settings);
            return DEFAULT_NODE_PREDICATE.and(node -> Booleans.parseBoolean(node.getAttributes().getOrDefault(attribute, "false")));
        }
        return DEFAULT_NODE_PREDICATE;
    }

    public boolean isCrossClusterSearchEnabled() {
        return !this.remoteClusters.isEmpty();
    }

    boolean isRemoteNodeConnected(String remoteCluster, DiscoveryNode node) {
        return this.remoteClusters.get(remoteCluster).isNodeConnected(node);
    }

    public Map<String, OriginalIndices> groupIndices(IndicesOptions indicesOptions, String[] indices, Predicate<String> indexExists) {
        HashMap<String, OriginalIndices> originalIndicesMap = new HashMap<String, OriginalIndices>();
        if (this.isCrossClusterSearchEnabled()) {
            Map<String, List<String>> groupedIndices = this.groupClusterIndices(this.getRemoteClusterNames(), indices, indexExists);
            if (groupedIndices.isEmpty()) {
                originalIndicesMap.put("", new OriginalIndices(Strings.EMPTY_ARRAY, indicesOptions));
            } else {
                for (Map.Entry<String, List<String>> entry : groupedIndices.entrySet()) {
                    String clusterAlias = entry.getKey();
                    List<String> originalIndices = entry.getValue();
                    originalIndicesMap.put(clusterAlias, new OriginalIndices(originalIndices.toArray(new String[0]), indicesOptions));
                }
            }
        } else {
            originalIndicesMap.put("", new OriginalIndices(indices, indicesOptions));
        }
        return originalIndicesMap;
    }

    boolean isRemoteClusterRegistered(String clusterName) {
        return this.remoteClusters.containsKey(clusterName);
    }

    public Set<String> getRegisteredRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    public Transport.Connection getConnection(DiscoveryNode node, String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection(node);
    }

    void ensureConnected(String clusterAlias, ActionListener<Void> listener) {
        this.getRemoteClusterConnection(clusterAlias).ensureConnected(listener);
    }

    public boolean isSkipUnavailable(String clusterAlias) {
        return this.getRemoteClusterConnection(clusterAlias).isSkipUnavailable();
    }

    public Transport.Connection getConnection(String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection();
    }

    RemoteClusterConnection getRemoteClusterConnection(String cluster) {
        RemoteClusterConnection connection = this.remoteClusters.get(cluster);
        if (connection == null) {
            throw new NoSuchRemoteClusterException(cluster);
        }
        return connection;
    }

    Set<String> getRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    @Override
    public void listenForUpdates(ClusterSettings clusterSettings) {
        super.listenForUpdates(clusterSettings);
        clusterSettings.addAffixUpdateConsumer(REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
        clusterSettings.addAffixUpdateConsumer(SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
    }

    private synchronized void updateSkipUnavailable(String clusterAlias, Boolean skipUnavailable) {
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (remote != null) {
            remote.updateSkipUnavailable(skipUnavailable);
        }
    }

    @Override
    protected void updateRemoteCluster(String clusterAlias, List<String> addresses, String proxyAddress, boolean compressionEnabled, TimeValue pingSchedule) {
        ConnectionProfile newProfile;
        if ("".equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        ConnectionProfile oldProfile = this.remoteClusterConnectionProfiles.get(clusterAlias);
        if (oldProfile != null) {
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder(oldProfile);
            builder.setCompressionEnabled(compressionEnabled);
            builder.setPingInterval(pingSchedule);
            newProfile = builder.build();
        } else {
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder(this.buildConnectionProfileFromSettings(clusterAlias));
            builder.setCompressionEnabled(compressionEnabled);
            builder.setPingInterval(pingSchedule);
            newProfile = builder.build();
        }
        this.updateRemoteCluster(clusterAlias, addresses, proxyAddress, newProfile, noopListener);
    }

    void updateRemoteCluster(String clusterAlias, List<String> addresses, String proxyAddress, ConnectionProfile connectionProfile, ActionListener<Void> connectionListener) {
        HashMap<String, ConnectionProfile> connectionProfiles = new HashMap<String, ConnectionProfile>(this.remoteClusterConnectionProfiles);
        connectionProfiles.put(clusterAlias, connectionProfile);
        this.remoteClusterConnectionProfiles = Collections.unmodifiableMap(connectionProfiles);
        List nodes = addresses.stream().map(address -> Tuple.tuple(address, () -> RemoteClusterService.buildSeedNode(clusterAlias, address, Strings.hasLength(proxyAddress)))).collect(Collectors.toList());
        this.updateRemoteClusters(Collections.singletonMap(clusterAlias, new Tuple(proxyAddress, nodes)), connectionListener);
    }

    void initializeRemoteClusters() {
        TimeValue timeValue = REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(this.settings);
        PlainActionFuture<Void> future = new PlainActionFuture<Void>();
        Map<String, Tuple<String, List<Tuple<String, Supplier<DiscoveryNode>>>>> seeds = RemoteClusterAware.buildRemoteClustersDynamicConfig(this.settings);
        this.initializeConnectionProfiles(seeds.keySet());
        this.updateRemoteClusters(seeds, future);
        try {
            future.get(timeValue.millis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            logger.warn("failed to connect to remote clusters within {}", (Object)timeValue.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to connect to remote clusters", e);
        }
    }

    private synchronized void initializeConnectionProfiles(Set<String> remoteClusters) {
        HashMap<String, ConnectionProfile> connectionProfiles = new HashMap<String, ConnectionProfile>(remoteClusters.size());
        for (String clusterName : remoteClusters) {
            connectionProfiles.put(clusterName, this.buildConnectionProfileFromSettings(clusterName));
        }
        this.remoteClusterConnectionProfiles = Collections.unmodifiableMap(connectionProfiles);
    }

    private ConnectionProfile buildConnectionProfileFromSettings(String clusterName) {
        return RemoteClusterService.buildConnectionProfileFromSettings(this.settings, clusterName);
    }

    static ConnectionProfile buildConnectionProfileFromSettings(Settings settings, String clusterName) {
        return new ConnectionProfile.Builder().setConnectTimeout(TransportSettings.CONNECT_TIMEOUT.get(settings)).setHandshakeTimeout(TransportSettings.CONNECT_TIMEOUT.get(settings)).addConnections(6, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.PING).addConnections(0, TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.STATE, TransportRequestOptions.Type.RECOVERY).setCompressionEnabled(REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(clusterName).get(settings)).setPingInterval(REMOTE_CLUSTER_PING_SCHEDULE.getConcreteSettingForNamespace(clusterName).get(settings)).build();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.remoteClusters.values());
    }

    public Stream<RemoteConnectionInfo> getRemoteConnectionInfos() {
        return this.remoteClusters.values().stream().map(RemoteClusterConnection::getConnectionInfo);
    }

    private boolean connectionProfileChanged(ConnectionProfile oldProfile, ConnectionProfile newProfile) {
        return !Objects.equals(oldProfile.getCompressionEnabled(), newProfile.getCompressionEnabled()) || !Objects.equals(oldProfile.getPingInterval(), newProfile.getPingInterval());
    }

    private boolean seedsChanged(List<Tuple<String, Supplier<DiscoveryNode>>> oldSeedNodes, List<Tuple<String, Supplier<DiscoveryNode>>> newSeedNodes) {
        Set newSeeds;
        if (oldSeedNodes.size() != newSeedNodes.size()) {
            return true;
        }
        Set oldSeeds = oldSeedNodes.stream().map(Tuple::v1).collect(Collectors.toSet());
        return !oldSeeds.equals(newSeeds = newSeedNodes.stream().map(Tuple::v1).collect(Collectors.toSet()));
    }

    public void collectNodes(Set<String> clusters, final ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        Map<String, RemoteClusterConnection> remoteClusters = this.remoteClusters;
        for (String cluster : clusters) {
            if (remoteClusters.containsKey(cluster)) continue;
            listener.onFailure(new NoSuchRemoteClusterException(cluster));
            return;
        }
        final HashMap clusterMap = new HashMap();
        final CountDown countDown = new CountDown(clusters.size());
        final Function<String, DiscoveryNode> nullFunction = s -> null;
        for (final String cluster : clusters) {
            RemoteClusterConnection connection = remoteClusters.get(cluster);
            connection.collectNodes(new ActionListener<Function<String, DiscoveryNode>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Function<String, DiscoveryNode> nodeLookup) {
                    Map map = clusterMap;
                    synchronized (map) {
                        clusterMap.put(cluster, nodeLookup);
                    }
                    if (countDown.countDown()) {
                        listener.onResponse((clusterAlias, nodeId) -> (DiscoveryNode)clusterMap.getOrDefault(clusterAlias, nullFunction).apply(nodeId));
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    public Client getRemoteClusterClient(ThreadPool threadPool, String clusterAlias) {
        if (!this.transportService.getRemoteClusterService().getRemoteClusterNames().contains(clusterAlias)) {
            throw new NoSuchRemoteClusterException(clusterAlias);
        }
        return new RemoteClusterAwareClient(this.settings, threadPool, this.transportService, clusterAlias);
    }

    Collection<RemoteClusterConnection> getConnections() {
        return this.remoteClusters.values();
    }

    static {
        assert (Version.CURRENT.major < 8);
        SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("search.remote.connections_per_cluster", 3, 1, Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_CONNECTIONS_PER_CLUSTER = Setting.intSetting("cluster.remote.connections_per_cluster", SEARCH_REMOTE_CONNECTIONS_PER_CLUSTER, 1, Setting.Property.NodeScope);
        SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("search.remote.initial_connect_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.remote.initial_connect_timeout", SEARCH_REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING, TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope);
        SEARCH_REMOTE_NODE_ATTRIBUTE = Setting.simpleString("search.remote.node.attr", Setting.Property.NodeScope, Setting.Property.Deprecated);
        REMOTE_NODE_ATTRIBUTE = Setting.simpleString("cluster.remote.node.attr", SEARCH_REMOTE_NODE_ATTRIBUTE, Setting.Property.NodeScope);
        SEARCH_ENABLE_REMOTE_CLUSTERS = Setting.boolSetting("search.remote.connect", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
        ENABLE_REMOTE_CLUSTERS = Setting.boolSetting("cluster.remote.connect", SEARCH_ENABLE_REMOTE_CLUSTERS, Setting.Property.NodeScope);
        SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("search.remote.", "skip_unavailable", key -> Setting.boolSetting(key, false, Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
        SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE_UPGRADER = new SettingUpgrader<Boolean>(){

            @Override
            public Setting<Boolean> getSetting() {
                return SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE;
            }

            @Override
            public String getKey(String key) {
                return key.replaceFirst("^search", "cluster");
            }
        };
        REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("cluster.remote.", "skip_unavailable", key -> Setting.boolSetting(key, "_na_".equals(key) ? SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSettingForNamespace((String)key) : SEARCH_REMOTE_CLUSTER_SKIP_UNAVAILABLE.getConcreteSetting(key.replaceAll("^cluster", "search")), Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
        REMOTE_CLUSTER_PING_SCHEDULE = Setting.affixKeySetting("cluster.remote.", "transport.ping_schedule", key -> Setting.timeSetting(key, TransportSettings.PING_SCHEDULE, Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
        REMOTE_CLUSTER_COMPRESS = Setting.affixKeySetting("cluster.remote.", "transport.compress", key -> Setting.boolSetting(key, TransportSettings.TRANSPORT_COMPRESS, Setting.Property.Dynamic, Setting.Property.NodeScope), REMOTE_CLUSTERS_SEEDS);
        DEFAULT_NODE_PREDICATE = node -> Version.CURRENT.isCompatible(node.getVersion()) && (!node.isMasterNode() || node.isDataNode() || node.isIngestNode());
    }
}

