/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortOrder;

public abstract class SortBuilder<T extends SortBuilder<T>>
implements NamedWriteable,
ToXContentObject,
Rewriteable<SortBuilder<?>> {
    protected SortOrder order = SortOrder.ASC;
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField NESTED_FILTER_FIELD = new ParseField("nested_filter", new String[0]);
    public static final ParseField NESTED_PATH_FIELD = new ParseField("nested_path", new String[0]);
    private static final Map<String, Parser<?>> PARSERS;

    protected abstract SortFieldAndFormat build(QueryShardContext var1) throws IOException;

    public T order(SortOrder order) {
        Objects.requireNonNull(order, "sort order cannot be null.");
        this.order = order;
        return (T)this;
    }

    public SortOrder order() {
        return this.order;
    }

    public static List<SortBuilder<?>> fromXContent(XContentParser parser) throws IOException {
        ArrayList sortFields = new ArrayList(2);
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    SortBuilder.parseCompoundSortField(parser, sortFields);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String fieldName = parser.text();
                    sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
                    continue;
                }
                throw new IllegalArgumentException("malformed sort format, within the sort array, an object, or an actual string are allowed");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            String fieldName = parser.text();
            sortFields.add(SortBuilder.fieldOrScoreSort(fieldName));
        } else if (token == XContentParser.Token.START_OBJECT) {
            SortBuilder.parseCompoundSortField(parser, sortFields);
        } else {
            throw new IllegalArgumentException("malformed sort format, either start with array, object, or an actual string");
        }
        return sortFields;
    }

    private static SortBuilder<?> fieldOrScoreSort(String fieldName) {
        if (fieldName.equals("_score")) {
            return new ScoreSortBuilder();
        }
        return new FieldSortBuilder(fieldName);
    }

    private static void parseCompoundSortField(XContentParser parser, List<SortBuilder<?>> sortFields) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                SortOrder order = SortOrder.fromString(parser.text());
                sortFields.add((SortBuilder<?>)SortBuilder.fieldOrScoreSort(fieldName).order(order));
                continue;
            }
            if (PARSERS.containsKey(fieldName)) {
                sortFields.add((SortBuilder<?>)PARSERS.get(fieldName).fromXContent(parser, fieldName));
                continue;
            }
            sortFields.add(FieldSortBuilder.fromXContent(parser, fieldName));
        }
    }

    public static Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders, QueryShardContext context) throws IOException {
        SortField sortField;
        boolean sort;
        ArrayList<SortField> sortFields = new ArrayList<SortField>(sortBuilders.size());
        ArrayList<DocValueFormat> sortFormats = new ArrayList<DocValueFormat>(sortBuilders.size());
        for (SortBuilder<?> builder : sortBuilders) {
            SortFieldAndFormat sf = builder.build(context);
            sortFields.add(sf.field);
            sortFormats.add(sf.format);
        }
        if (!sortFields.isEmpty() && (sort = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != SortField.Type.SCORE || sortField.getReverse())) {
            return Optional.of(new SortAndFormats(new Sort(sortFields.toArray(new SortField[sortFields.size()])), sortFormats.toArray(new DocValueFormat[sortFormats.size()])));
        }
        return Optional.empty();
    }

    protected static IndexFieldData.XFieldComparatorSource.Nested resolveNested(QueryShardContext context, String nestedPath, QueryBuilder nestedFilter) throws IOException {
        NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(nestedPath);
        nestedSortBuilder.setFilter(nestedFilter);
        return SortBuilder.resolveNested(context, nestedSortBuilder);
    }

    protected static IndexFieldData.XFieldComparatorSource.Nested resolveNested(QueryShardContext context, NestedSortBuilder nestedSort) throws IOException {
        Query childQuery = SortBuilder.resolveNestedQuery(context, nestedSort, null);
        if (childQuery == null) {
            return null;
        }
        ObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        Query parentQuery = objectMapper == null ? Queries.newNonNestedFilter(context.indexVersionCreated()) : objectMapper.nestedTypeFilter();
        return new IndexFieldData.XFieldComparatorSource.Nested(context.bitsetFilter(parentQuery), childQuery, nestedSort, context::newCachedSearcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query resolveNestedQuery(QueryShardContext context, NestedSortBuilder nestedSort, Query parentQuery) throws IOException {
        Query childQuery;
        if (nestedSort == null || nestedSort.getPath() == null) {
            return null;
        }
        String nestedPath = nestedSort.getPath();
        QueryBuilder nestedFilter = nestedSort.getFilter();
        NestedSortBuilder nestedNestedSort = nestedSort.getNestedSort();
        ObjectMapper nestedObjectMapper = context.getObjectMapper(nestedPath);
        if (nestedObjectMapper == null) {
            throw new QueryShardException(context, "[nested] failed to find nested object under path [" + nestedPath + "]", new Object[0]);
        }
        if (!nestedObjectMapper.nested().isNested()) {
            throw new QueryShardException(context, "[nested] nested object under path [" + nestedPath + "] is not of nested type", new Object[0]);
        }
        ObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        try {
            context.nestedScope().nextLevel(nestedObjectMapper);
            if (nestedFilter != null) {
                assert (nestedFilter == Rewriteable.rewrite(nestedFilter, (QueryRewriteContext)context)) : "nested filter is not rewritten";
                childQuery = parentQuery == null ? nestedFilter.toQuery(context) : Queries.filtered(nestedObjectMapper.nestedTypeFilter(), nestedFilter.toQuery(context));
            } else {
                childQuery = nestedObjectMapper.nestedTypeFilter();
            }
        }
        finally {
            context.nestedScope().previousLevel();
        }
        if (parentQuery != null && objectMapper != null) {
            childQuery = Queries.filtered(childQuery, (Query)new ToChildBlockJoinQuery(parentQuery, context.bitsetFilter(objectMapper.nestedTypeFilter())));
        }
        if (nestedNestedSort != null) {
            try {
                context.nestedScope().nextLevel(nestedObjectMapper);
                Query query = SortBuilder.resolveNestedQuery(context, nestedNestedSort, childQuery);
                return query;
            }
            finally {
                context.nestedScope().previousLevel();
            }
        }
        return childQuery;
    }

    protected static QueryBuilder parseNestedFilter(XContentParser parser) {
        try {
            return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Expected " + NESTED_FILTER_FIELD.getPreferredName() + " element.", e, new Object[0]);
        }
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        HashMap<String, Parser<SortBuilder>> parsers = new HashMap<String, Parser<SortBuilder>>();
        parsers.put("_script", ScriptSortBuilder::fromXContent);
        parsers.put("_geo_distance", GeoDistanceSortBuilder::fromXContent);
        parsers.put("_geoDistance", GeoDistanceSortBuilder::fromXContent);
        parsers.put("_score", ScoreSortBuilder::fromXContent);
        PARSERS = Collections.unmodifiableMap(parsers);
    }

    @FunctionalInterface
    private static interface Parser<T extends SortBuilder<?>> {
        public T fromXContent(XContentParser var1, String var2) throws IOException;
    }
}

