/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.CorruptStateException;

public final class ChecksumBlobStoreFormat<T extends ToXContent> {
    private static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final boolean compress;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedFunction<XContentParser, T, IOException> reader;
    private final NamedXContentRegistry namedXContentRegistry;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.namedXContentRegistry = namedXContentRegistry;
        this.compress = compress;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        return this.readBlob(blobContainer, blobName);
    }

    public void delete(BlobContainer blobContainer, String name) throws IOException {
        blobContainer.deleteBlob(this.blobName(name));
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        BytesReference bytes = Streams.readFully(blobContainer.readBlob(blobName));
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try (ByteArrayIndexInput indexInput = new ByteArrayIndexInput(resourceDesc, BytesReference.toBytes(bytes));){
            ToXContent toXContent;
            block13: {
                CodecUtil.checksumEntireFile(indexInput);
                CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
                long filePointer = indexInput.getFilePointer();
                long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
                XContentParser parser = XContentHelper.createParser(this.namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), XContentType.SMILE);
                try {
                    toXContent = (ToXContent)this.reader.apply(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return (T)toXContent;
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void writeAtomic(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlobAtomic(blobName, stream, bytesArray.length(), true);
            }
        });
    }

    public void write(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlob(blobName, stream, bytesArray.length(), true);
            }
        });
    }

    private void writeTo(T obj, String blobName, CheckedConsumer<BytesArray, IOException> consumer) throws IOException {
        BytesReference bytes;
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            if (this.compress) {
                try (StreamOutput compressedStreamOutput = CompressorFactory.COMPRESSOR.streamOutput(bytesStreamOutput);){
                    this.write(obj, compressedStreamOutput);
                }
            } else {
                this.write(obj, bytesStreamOutput);
            }
            bytes = bytesStreamOutput.bytes();
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String resourceDesc = "ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")";
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, blobName, outputStream, 4096);){
                CodecUtil.writeHeader(indexOutput, this.codec, 1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };){
                    bytes.writeTo(indexOutputOutputStream);
                }
                CodecUtil.writeFooter(indexOutput);
            }
            consumer.accept(new BytesArray(outputStream.toByteArray()));
        }
    }

    private void write(T obj, StreamOutput streamOutput) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(XContentType.SMILE, streamOutput);){
            builder.startObject();
            obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
            builder.endObject();
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", MetaData.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

