/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.uhighlight.CustomFieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.Snippet;
import org.apache.lucene.search.uhighlight.SplittingBreakIterator;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;

public class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    public static final char MULTIVAL_SEP_CHAR = '\u0000';
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final UnifiedHighlighter.OffsetSource offsetSource;
    private final String fieldValue;
    private final PassageFormatter passageFormatter;
    private final BreakIterator breakIterator;
    private final Locale breakIteratorLocale;
    private final int noMatchSize;

    public CustomUnifiedHighlighter(IndexSearcher searcher, Analyzer analyzer, UnifiedHighlighter.OffsetSource offsetSource, PassageFormatter passageFormatter, @Nullable Locale breakIteratorLocale, @Nullable BreakIterator breakIterator, String fieldValue, int noMatchSize) {
        super(searcher, analyzer);
        this.offsetSource = offsetSource;
        this.breakIterator = breakIterator;
        this.breakIteratorLocale = breakIteratorLocale == null ? Locale.ROOT : breakIteratorLocale;
        this.passageFormatter = passageFormatter;
        this.fieldValue = fieldValue;
        this.noMatchSize = noMatchSize;
    }

    public Snippet[] highlightField(String field, Query query, int docId, int maxPassages) throws IOException {
        Map fieldsAsObjects = super.highlightFieldsAsObjects(new String[]{field}, query, new int[]{docId}, new int[]{maxPassages});
        Object[] snippetObjects = (Object[])fieldsAsObjects.get(field);
        if (snippetObjects != null) {
            assert (snippetObjects.length == 1);
            Object snippetObject = snippetObjects[0];
            if (snippetObject != null && snippetObject instanceof Snippet[]) {
                return (Snippet[])snippetObject;
            }
        }
        return EMPTY_SNIPPET;
    }

    protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
        return Collections.singletonList(new String[]{this.fieldValue});
    }

    protected BreakIterator getBreakIterator(String field) {
        return this.breakIterator;
    }

    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    protected FieldHighlighter getFieldHighlighter(String field, Query query, Set<Term> allTerms, int maxPassages) {
        Predicate fieldMatcher = this.getFieldMatcher(field);
        BytesRef[] terms = CustomUnifiedHighlighter.filterExtractedTerms((Predicate)fieldMatcher, allTerms);
        Set highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        CharacterRunAutomaton[] automata = this.getAutomata(field, query, highlightFlags);
        UHComponents components = new UHComponents(field, fieldMatcher, query, terms, phraseHelper, automata, false, highlightFlags);
        UnifiedHighlighter.OffsetSource offsetSource = this.getOptimizedOffsetSource(components);
        SplittingBreakIterator breakIterator = new SplittingBreakIterator(this.getBreakIterator(field), '\u0000');
        FieldOffsetStrategy strategy = this.getOffsetStrategy(offsetSource, components);
        return new CustomFieldHighlighter(field, strategy, this.breakIteratorLocale, (BreakIterator)breakIterator, this.getScorer(field), maxPassages, this.noMatchSize > 0 ? 1 : 0, this.getFormatter(field), this.noMatchSize, this.fieldValue);
    }

    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    private Collection<Query> rewriteCustomQuery(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            if (positionSpanQueries.length == 1) {
                return Collections.singletonList(positionSpanQueries[0]);
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        return null;
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
        if (this.offsetSource == null) {
            return super.getOffsetSource(field);
        }
        return this.offsetSource;
    }
}

