/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.cumulativecardinality;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xpack.analytics.AnalyticsPlugin;
import org.elasticsearch.xpack.analytics.cumulativecardinality.CumulativeCardinalityPipelineAggregator;

public class CumulativeCardinalityPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<CumulativeCardinalityPipelineAggregationBuilder> {
    public static final String NAME = "cumulative_cardinality";
    private String format;
    private static final Function<String, ConstructingObjectParser<CumulativeCardinalityPipelineAggregationBuilder, Void>> PARSER = name -> {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, false, o -> new CumulativeCardinalityPipelineAggregationBuilder((String)name, (String)o[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        parser.declareString(CumulativeCardinalityPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
        return parser;
    };

    public CumulativeCardinalityPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public CumulativeCardinalityPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
    }

    public CumulativeCardinalityPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        return new CumulativeCardinalityPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), metaData);
    }

    public void doValidate(AggregatorFactory parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        if (this.bucketsPaths.length != 1) {
            throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        CumulativeCardinalityPipelineAggregationBuilder.validateSequentiallyOrderedParentAggs((AggregatorFactory)parent, (String)NAME, (String)this.name);
    }

    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        return builder;
    }

    public static CumulativeCardinalityPipelineAggregationBuilder parse(String aggName, XContentParser parser) {
        if (!AnalyticsPlugin.getLicenseState().isAnalyticsAllowed()) {
            throw LicenseUtils.newComplianceException((String)"analytics");
        }
        AnalyticsPlugin.cumulativeCardUsage.incrementAndGet();
        return (CumulativeCardinalityPipelineAggregationBuilder)((Object)PARSER.apply(aggName).apply(parser, null));
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CumulativeCardinalityPipelineAggregationBuilder other = (CumulativeCardinalityPipelineAggregationBuilder)((Object)obj);
        return Objects.equals(this.format, other.format);
    }

    public String getWriteableName() {
        return NAME;
    }
}

