/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.rest;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ccr.action.ForgetFollowerAction;

public class RestForgetFollowerAction
extends BaseRestHandler {
    public RestForgetFollowerAction(RestController restController) {
        Objects.requireNonNull(restController);
        restController.registerHandler(RestRequest.Method.POST, "/{index}/_ccr/forget_follower", (RestHandler)this);
    }

    public String getName() {
        return "forget_follower_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String leaderIndex = restRequest.param("index");
        return channel -> {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                ForgetFollowerAction.Request request = ForgetFollowerAction.Request.fromXContent((XContentParser)parser, (String)leaderIndex);
                client.execute((ActionType)ForgetFollowerAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
            }
            catch (IOException e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, (Exception)e));
            }
        };
    }
}

