/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;

public class TransportPutAutoFollowPatternAction
extends TransportMasterNodeAction<PutAutoFollowPatternAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportPutAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client, IndexNameExpressionResolver indexNameExpressionResolver, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/put", transportService, clusterService, threadPool, actionFilters, PutAutoFollowPatternAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(final PutAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        Client remoteClient = this.client.getRemoteClusterClient(request.getRemoteCluster());
        final Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ShardFollowTask.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Consumer<ClusterStateResponse> consumer = remoteClusterState -> {
            String[] indices = request.getLeaderIndexPatterns().toArray(new String[0]);
            this.ccrLicenseChecker.hasPrivilegesToFollowIndices(remoteClient, indices, e -> {
                if (e == null) {
                    this.clusterService.submitStateUpdateTask("put-auto-follow-pattern-" + request.getRemoteCluster(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

                        protected AcknowledgedResponse newResponse(boolean acknowledged) {
                            return new AcknowledgedResponse(acknowledged);
                        }

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            return TransportPutAutoFollowPatternAction.innerPut(request, filteredHeaders, currentState, remoteClusterState.getState());
                        }
                    });
                } else {
                    listener.onFailure(e);
                }
            });
        };
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear();
        clusterStateRequest.metaData(true);
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(this.client, request.getRemoteCluster(), clusterStateRequest, arg_0 -> listener.onFailure(arg_0), consumer);
    }

    static ClusterState innerPut(PutAutoFollowPatternAction.Request request, Map<String, String> filteredHeaders, ClusterState localState, ClusterState remoteClusterState) {
        HashMap<String, Map<String, String>> headers;
        HashMap<String, ArrayList<String>> followedLeaderIndices;
        HashMap<String, AutoFollowMetadata.AutoFollowPattern> patterns;
        AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)localState.metaData().custom("ccr_auto_follow");
        if (currentAutoFollowMetadata != null) {
            patterns = new HashMap(currentAutoFollowMetadata.getPatterns());
            followedLeaderIndices = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
            headers = new HashMap(currentAutoFollowMetadata.getHeaders());
        } else {
            patterns = new HashMap<String, AutoFollowMetadata.AutoFollowPattern>();
            followedLeaderIndices = new HashMap<String, ArrayList<String>>();
            headers = new HashMap<String, Map<String, String>>();
        }
        AutoFollowMetadata.AutoFollowPattern previousPattern = (AutoFollowMetadata.AutoFollowPattern)patterns.get(request.getName());
        ArrayList<String> followedIndexUUIDs = followedLeaderIndices.containsKey(request.getName()) ? new ArrayList((Collection)followedLeaderIndices.get(request.getName())) : new ArrayList<String>();
        followedLeaderIndices.put(request.getName(), followedIndexUUIDs);
        if (previousPattern != null) {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowedForNewPatterns(request.getLeaderIndexPatterns(), remoteClusterState.metaData(), previousPattern, followedIndexUUIDs);
        } else {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(request.getLeaderIndexPatterns(), remoteClusterState.metaData(), followedIndexUUIDs);
        }
        if (filteredHeaders != null) {
            headers.put(request.getName(), filteredHeaders);
        }
        AutoFollowMetadata.AutoFollowPattern autoFollowPattern = new AutoFollowMetadata.AutoFollowPattern(request.getRemoteCluster(), request.getLeaderIndexPatterns(), request.getFollowIndexNamePattern(), request.getParameters().getMaxReadRequestOperationCount(), request.getParameters().getMaxWriteRequestOperationCount(), request.getParameters().getMaxOutstandingReadRequests(), request.getParameters().getMaxOutstandingWriteRequests(), request.getParameters().getMaxReadRequestSize(), request.getParameters().getMaxWriteRequestSize(), request.getParameters().getMaxWriteBufferCount(), request.getParameters().getMaxWriteBufferSize(), request.getParameters().getMaxRetryDelay(), request.getParameters().getReadPollTimeout());
        patterns.put(request.getName(), autoFollowPattern);
        ClusterState.Builder newState = ClusterState.builder((ClusterState)localState);
        newState.metaData(MetaData.builder((MetaData)localState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)new AutoFollowMetadata(patterns, followedLeaderIndices, headers)).build());
        return newState.build();
    }

    private static void markExistingIndicesAsAutoFollowedForNewPatterns(List<String> leaderIndexPatterns, MetaData leaderMetaData, AutoFollowMetadata.AutoFollowPattern previousPattern, List<String> followedIndexUUIDS) {
        List<String> newPatterns = leaderIndexPatterns.stream().filter(p -> !previousPattern.getLeaderIndexPatterns().contains(p)).collect(Collectors.toList());
        TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(newPatterns, leaderMetaData, followedIndexUUIDS);
    }

    private static void markExistingIndicesAsAutoFollowed(List<String> patterns, MetaData leaderMetaData, List<String> followedIndexUUIDS) {
        for (IndexMetaData indexMetaData : leaderMetaData) {
            if (!AutoFollowMetadata.AutoFollowPattern.match(patterns, (String)indexMetaData.getIndex().getName())) continue;
            followedIndexUUIDS.add(indexMetaData.getIndexUUID());
        }
    }

    protected ClusterBlockException checkBlock(PutAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

