/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    public static final IndexTemplateConfig TEMPLATE_CONFIG_TRIGGERED_WATCHES = new IndexTemplateConfig(".triggered_watches", "/triggered-watches.json", "10", "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new IndexTemplateConfig(".watch-history-10", "/watch-history.json", "10", "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM = new IndexTemplateConfig(".watch-history-no-ilm-10", "/watch-history-no-ilm.json", "10", "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCHES = new IndexTemplateConfig(".watches", "/watches.json", "10", "xpack.watcher.template.version");
    public static final LifecyclePolicyConfig POLICY_WATCH_HISTORY = new LifecyclePolicyConfig("watch-history-ilm-policy", "/watch-history-ilm-policy.json");
    private final List<IndexTemplateConfig> templatesToUse;

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        boolean ilmEnabled = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(this.settings);
        this.templatesToUse = Arrays.asList(ilmEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM, TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCHES);
    }

    protected List<IndexTemplateConfig> getTemplateConfigs() {
        return this.templatesToUse;
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        return Collections.singletonList(POLICY_WATCH_HISTORY);
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        return (state.getMetaData().getTemplates().containsKey((Object)".watch-history-10") || state.getMetaData().getTemplates().containsKey((Object)".watch-history-no-ilm-10")) && state.getMetaData().getTemplates().containsKey((Object)".triggered_watches") && state.getMetaData().getTemplates().containsKey((Object)".watches");
    }
}

