/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestAckWatchAction
extends WatcherRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestAckWatchAction.class));

    public RestAckWatchAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_watcher/watch/{id}/_ack", (RestHandler)this, RestRequest.Method.POST, URI_BASE + "/watcher/watch/{id}/_ack", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack", (RestHandler)this, RestRequest.Method.PUT, URI_BASE + "/watcher/watch/{id}/_ack", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_watcher/watch/{id}/_ack/{actions}", (RestHandler)this, RestRequest.Method.POST, URI_BASE + "/watcher/watch/{id}/_ack/{actions}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack/{actions}", (RestHandler)this, RestRequest.Method.PUT, URI_BASE + "/watcher/watch/{id}/_ack/{actions}", deprecationLogger);
    }

    public String getName() {
        return "watcher_ack_watch";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
        AckWatchRequest ackWatchRequest = new AckWatchRequest(request.param("id"), new String[0]);
        String[] actions = request.paramAsStringArray("actions", null);
        if (actions != null) {
            ackWatchRequest.setActionIds(actions);
        }
        return channel -> client.ackWatch(ackWatchRequest, (ActionListener)new RestBuilderListener<AckWatchResponse>(channel){

            public RestResponse buildResponse(AckWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }
}

