/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherXContentParser;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.trigger.Trigger;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;
import org.elasticsearch.xpack.watcher.condition.InternalAlwaysCondition;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.none.ExecutableNoneInput;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class WatchParser {
    private static final Logger logger = LogManager.getLogger(WatchParser.class);
    private final TriggerService triggerService;
    private final ActionRegistry actionRegistry;
    private final InputRegistry inputRegistry;
    private final CryptoService cryptoService;
    private final Clock clock;
    private final ExecutableInput defaultInput;
    private final ExecutableCondition defaultCondition;
    private final List<ActionWrapper> defaultActions;

    public WatchParser(TriggerService triggerService, ActionRegistry actionRegistry, InputRegistry inputRegistry, @Nullable CryptoService cryptoService, Clock clock) {
        this.triggerService = triggerService;
        this.actionRegistry = actionRegistry;
        this.inputRegistry = inputRegistry;
        this.cryptoService = cryptoService;
        this.clock = clock;
        this.defaultInput = new ExecutableNoneInput();
        this.defaultCondition = InternalAlwaysCondition.INSTANCE;
        this.defaultActions = Collections.emptyList();
    }

    public Watch parse(String name, boolean includeStatus, BytesReference source, XContentType xContentType, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
        return this.parse(name, includeStatus, false, source, now, xContentType, false, sourceSeqNo, sourcePrimaryTerm);
    }

    public Watch parse(String name, boolean includeStatus, BytesReference source, ZonedDateTime now, XContentType xContentType, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        return this.parse(name, includeStatus, false, source, now, xContentType, false, sourceSeqNo, sourcePrimaryTerm);
    }

    public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, ZonedDateTime now, XContentType xContentType, boolean allowRedactedPasswords, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        return this.parse(id, includeStatus, true, source, now, xContentType, allowRedactedPasswords, sourceSeqNo, sourcePrimaryTerm);
    }

    public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, ZonedDateTime now, XContentType xContentType, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        return this.parse(id, includeStatus, true, source, now, xContentType, false, sourceSeqNo, sourcePrimaryTerm);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Watch parse(String id, boolean includeStatus, boolean withSecrets, BytesReference source, ZonedDateTime now, XContentType xContentType, boolean allowRedactedPasswords, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("parsing watch [{}] ", (Object)source.utf8ToString());
        }
        try (StreamInput stream = source.streamInput();){
            Watch watch;
            try (WatcherXContentParser parser = new WatcherXContentParser(xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream), now, withSecrets ? this.cryptoService : null, allowRedactedPasswords);){
                parser.nextToken();
                watch = this.parse(id, includeStatus, parser, sourceSeqNo, sourcePrimaryTerm);
            }
            return watch;
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"could not parse watch [{}]", (Throwable)ioe, (Object[])new Object[]{id});
        }
    }

    public Watch parse(String id, boolean includeStatus, WatcherXContentParser parser, long sourceSeqNo, long sourcePrimaryTerm) throws IOException {
        XContentParser.Token token;
        Trigger trigger = null;
        ExecutableInput<?, ?> input = this.defaultInput;
        ExecutableCondition condition = this.defaultCondition;
        List actions = this.defaultActions;
        ExecutableTransform transform = null;
        TimeValue throttlePeriod = null;
        Map metatdata = null;
        WatchStatus status = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == null) {
                throw new ElasticsearchParseException("could not parse watch [{}]. null token", new Object[]{id});
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == null || currentFieldName == null) {
                throw new ElasticsearchParseException("could not parse watch [{}], unexpected token [{}]", new Object[]{id, token});
            }
            if (WatchField.TRIGGER.match(currentFieldName, parser.getDeprecationHandler())) {
                trigger = this.triggerService.parseTrigger(id, (XContentParser)parser);
                continue;
            }
            if (WatchField.INPUT.match(currentFieldName, parser.getDeprecationHandler())) {
                input = this.inputRegistry.parse(id, (XContentParser)parser);
                continue;
            }
            if (WatchField.CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                condition = this.actionRegistry.getConditionRegistry().parseExecutable(id, (XContentParser)parser);
                continue;
            }
            if (WatchField.TRANSFORM.match(currentFieldName, parser.getDeprecationHandler())) {
                transform = this.actionRegistry.getTransformRegistry().parse(id, (XContentParser)parser);
                continue;
            }
            if (WatchField.THROTTLE_PERIOD.match(currentFieldName, parser.getDeprecationHandler())) {
                throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (WatchField.THROTTLE_PERIOD_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)WatchField.THROTTLE_PERIOD_HUMAN.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse watch [{}]. failed to parse time value for field [{}]", (Throwable)pe, new Object[]{id, currentFieldName});
                }
            }
            if (WatchField.ACTIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                actions = this.actionRegistry.parseActions(id, (XContentParser)parser);
                continue;
            }
            if (WatchField.METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                metatdata = parser.map();
                continue;
            }
            if (WatchField.STATUS.match(currentFieldName, parser.getDeprecationHandler())) {
                if (includeStatus) {
                    status = WatchStatus.parse((String)id, (WatcherXContentParser)parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            throw new ElasticsearchParseException("could not parse watch [{}]. unexpected field [{}]", new Object[]{id, currentFieldName});
        }
        if (trigger == null) {
            throw new ElasticsearchParseException("could not parse watch [{}]. missing required field [{}]", new Object[]{id, WatchField.TRIGGER.getPreferredName()});
        }
        if (status != null) {
            for (ActionWrapper action : actions) {
                if (status.actionStatus(action.id()) != null) continue;
                throw new ElasticsearchParseException("could not parse watch [{}]. watch status in invalid state. action [{}] status is missing", new Object[]{id, action.id()});
            }
        } else {
            HashMap<String, ActionStatus> actionsStatuses = new HashMap<String, ActionStatus>();
            for (ActionWrapper action : actions) {
                actionsStatuses.put(action.id(), new ActionStatus(parser.getParseDateTime()));
            }
            status = new WatchStatus(parser.getParseDateTime(), Collections.unmodifiableMap(actionsStatuses));
        }
        return new Watch(id, trigger, (ExecutableInput)input, condition, transform, throttlePeriod, actions, metatdata, status, sourceSeqNo, sourcePrimaryTerm);
    }
}

