/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

abstract class WatcherTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final XPackLicenseState licenseState;

    WatcherTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, Writeable.Reader<Request> request) {
        super(actionName, transportService, actionFilters, request);
        this.licenseState = licenseState;
    }

    protected String executor() {
        return "generic";
    }

    protected final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        if (this.licenseState.checkFeature(XPackLicenseState.Feature.WATCHER)) {
            this.doExecute(request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"watcher"));
        }
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);
}

