/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.common.http.HttpMethod;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.Scheme;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEventContext;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEventDefaults;

public class IncidentEvent
implements ToXContentObject {
    static final String HOST = "events.pagerduty.com";
    static final String PATH = "/v2/enqueue";
    static final String ACCEPT_HEADER = "application/vnd.pagerduty+json;version=2";
    final String description;
    @Nullable
    final HttpProxy proxy;
    @Nullable
    final String incidentKey;
    @Nullable
    final String client;
    @Nullable
    final String clientUrl;
    @Nullable
    final String account;
    final String eventType;
    final boolean attachPayload;
    @Nullable
    final IncidentEventContext[] contexts;

    public IncidentEvent(String description, @Nullable String eventType, @Nullable String incidentKey, @Nullable String client, @Nullable String clientUrl, @Nullable String account, boolean attachPayload, @Nullable IncidentEventContext[] contexts, @Nullable HttpProxy proxy) {
        this.description = description;
        if (description == null) {
            throw new IllegalStateException("could not create pagerduty event. missing required [" + Fields.DESCRIPTION.getPreferredName() + "] setting");
        }
        this.incidentKey = incidentKey;
        this.client = client;
        this.clientUrl = clientUrl;
        this.account = account;
        this.proxy = proxy;
        this.attachPayload = attachPayload;
        this.contexts = contexts;
        this.eventType = Strings.hasLength((String)eventType) ? eventType : "trigger";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentEvent template = (IncidentEvent)o;
        return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.account, template.account) && Objects.equals(this.proxy, template.proxy) && Arrays.equals(this.contexts, template.contexts);
    }

    public int hashCode() {
        int result = Objects.hash(this.description, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, this.eventType, this.proxy);
        result = 31 * result + Arrays.hashCode(this.contexts);
        return result;
    }

    HttpRequest createRequest(String serviceKey, Payload payload, String watchId) throws IOException {
        return HttpRequest.builder(HOST, -1).method(HttpMethod.POST).scheme(Scheme.HTTPS).path(PATH).proxy(this.proxy).setHeader("Accept", ACCEPT_HEADER).jsonBody((b, p) -> this.buildAPIXContent(b, p, serviceKey, payload, watchId)).build();
    }

    XContentBuilder buildAPIXContent(XContentBuilder builder, ToXContent.Params params, String serviceKey, Payload payload, String watchId) throws IOException {
        builder.field(Fields.ROUTING_KEY.getPreferredName(), serviceKey);
        builder.field(Fields.EVENT_ACTION.getPreferredName(), this.eventType);
        if (this.incidentKey != null) {
            builder.field(Fields.DEDUP_KEY.getPreferredName(), this.incidentKey);
        }
        builder.startObject(Fields.PAYLOAD.getPreferredName());
        builder.field(Fields.SUMMARY.getPreferredName(), this.description);
        if (this.attachPayload && payload != null) {
            builder.startObject(Fields.CUSTOM_DETAILS.getPreferredName());
            builder.field(Fields.PAYLOAD.getPreferredName(), (ToXContent)payload, params);
            builder.endObject();
        }
        if (watchId != null) {
            builder.field(Fields.SOURCE.getPreferredName(), watchId);
        } else {
            builder.field(Fields.SOURCE.getPreferredName(), "watcher");
        }
        builder.field(Fields.SEVERITY.getPreferredName(), "critical");
        builder.endObject();
        if (this.client != null) {
            builder.field(Fields.CLIENT.getPreferredName(), this.client);
        }
        if (this.clientUrl != null) {
            builder.field(Fields.CLIENT_URL.getPreferredName(), this.clientUrl);
        }
        if (this.contexts != null && this.contexts.length > 0) {
            this.toXContentV2Contexts(builder, params, this.contexts);
        }
        return builder;
    }

    private void toXContentV2Contexts(XContentBuilder builder, ToXContent.Params params, IncidentEventContext[] contexts) throws IOException {
        List images;
        Map<IncidentEventContext.Type, List<IncidentEventContext>> groups = Arrays.stream(contexts).collect(Collectors.groupingBy(iec -> iec.type));
        List links = groups.getOrDefault((Object)IncidentEventContext.Type.LINK, Collections.emptyList());
        if (!links.isEmpty()) {
            builder.array(Fields.LINKS.getPreferredName(), links.toArray());
        }
        if (!(images = groups.getOrDefault((Object)IncidentEventContext.Type.IMAGE, Collections.emptyList())).isEmpty()) {
            builder.array(Fields.IMAGES.getPreferredName(), images.toArray());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.DESCRIPTION.getPreferredName(), this.description);
        if (this.incidentKey != null) {
            builder.field(Fields.INCIDENT_KEY.getPreferredName(), this.incidentKey);
        }
        if (this.client != null) {
            builder.field(Fields.CLIENT.getPreferredName(), this.client);
        }
        if (this.clientUrl != null) {
            builder.field(Fields.CLIENT_URL.getPreferredName(), this.clientUrl);
        }
        if (this.account != null) {
            builder.field(Fields.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        builder.field(Fields.ATTACH_PAYLOAD.getPreferredName(), this.attachPayload);
        if (this.contexts != null) {
            builder.startArray(Fields.CONTEXTS.getPreferredName());
            for (IncidentEventContext context : this.contexts) {
                context.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static Template.Builder templateBuilder(String description) {
        return IncidentEvent.templateBuilder(new TextTemplate(description));
    }

    public static Template.Builder templateBuilder(TextTemplate description) {
        return new Template.Builder(description);
    }

    static interface Fields {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField EVENT_TYPE = new ParseField("event_type", new String[0]);
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
        public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
        public static final ParseField INCIDENT_KEY = new ParseField("incident_key", new String[0]);
        public static final ParseField CLIENT = new ParseField("client", new String[0]);
        public static final ParseField CLIENT_URL = new ParseField("client_url", new String[0]);
        public static final ParseField ATTACH_PAYLOAD = new ParseField("attach_payload", new String[0]);
        public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
        public static final ParseField CONTEXT_DEPRECATED = new ParseField("context", new String[0]);
        public static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        public static final ParseField ROUTING_KEY = new ParseField("routing_key", new String[0]);
        public static final ParseField EVENT_ACTION = new ParseField("event_action", new String[0]);
        public static final ParseField DEDUP_KEY = new ParseField("dedup_key", new String[0]);
        public static final ParseField SUMMARY = new ParseField("summary", new String[0]);
        public static final ParseField SOURCE = new ParseField("source", new String[0]);
        public static final ParseField SEVERITY = new ParseField("severity", new String[0]);
        public static final ParseField LINKS = new ParseField("links", new String[0]);
        public static final ParseField IMAGES = new ParseField("images", new String[0]);
        public static final ParseField CUSTOM_DETAILS = new ParseField("custom_details", new String[0]);
    }

    public static class Template
    implements ToXContentObject {
        final TextTemplate description;
        final TextTemplate incidentKey;
        final TextTemplate client;
        final TextTemplate clientUrl;
        final TextTemplate eventType;
        public final String account;
        final Boolean attachPayload;
        final IncidentEventContext.Template[] contexts;
        final HttpProxy proxy;

        public Template(TextTemplate description, TextTemplate eventType, TextTemplate incidentKey, TextTemplate client, TextTemplate clientUrl, String account, Boolean attachPayload, IncidentEventContext.Template[] contexts, HttpProxy proxy) {
            this.description = description;
            this.eventType = eventType;
            this.incidentKey = incidentKey;
            this.client = client;
            this.clientUrl = clientUrl;
            this.account = account;
            this.attachPayload = attachPayload;
            this.contexts = contexts;
            this.proxy = proxy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.description, template.description) && Objects.equals(this.incidentKey, template.incidentKey) && Objects.equals(this.client, template.client) && Objects.equals(this.clientUrl, template.clientUrl) && Objects.equals(this.eventType, template.eventType) && Objects.equals(this.attachPayload, template.attachPayload) && Objects.equals(this.account, template.account) && Objects.equals(this.proxy, template.proxy) && Arrays.equals(this.contexts, template.contexts);
        }

        public int hashCode() {
            int result = Objects.hash(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.attachPayload, this.account, this.proxy);
            result = 31 * result + Arrays.hashCode(this.contexts);
            return result;
        }

        public IncidentEvent render(String watchId, String actionId, TextTemplateEngine engine, Map<String, Object> model, IncidentEventDefaults defaults) {
            String description;
            String string = description = this.description != null ? engine.render(this.description, model) : defaults.description;
            String incidentKey = this.incidentKey != null ? engine.render(this.incidentKey, model) : (defaults.incidentKey != null ? defaults.incidentKey : watchId);
            String client = this.client != null ? engine.render(this.client, model) : defaults.client;
            String clientUrl = this.clientUrl != null ? engine.render(this.clientUrl, model) : defaults.clientUrl;
            String eventType = this.eventType != null ? engine.render(this.eventType, model) : defaults.eventType;
            boolean attachPayload = this.attachPayload != null ? this.attachPayload : defaults.attachPayload;
            IncidentEventContext[] contexts = null;
            if (this.contexts != null) {
                contexts = new IncidentEventContext[this.contexts.length];
                for (int i = 0; i < this.contexts.length; ++i) {
                    contexts[i] = this.contexts[i].render(engine, model, defaults);
                }
            }
            return new IncidentEvent(description, eventType, incidentKey, client, clientUrl, this.account, attachPayload, contexts, this.proxy);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.DESCRIPTION.getPreferredName(), (ToXContent)this.description, params);
            if (this.incidentKey != null) {
                builder.field(Fields.INCIDENT_KEY.getPreferredName(), (ToXContent)this.incidentKey, params);
            }
            if (this.client != null) {
                builder.field(Fields.CLIENT.getPreferredName(), (ToXContent)this.client, params);
            }
            if (this.clientUrl != null) {
                builder.field(Fields.CLIENT_URL.getPreferredName(), (ToXContent)this.clientUrl, params);
            }
            if (this.eventType != null) {
                builder.field(Fields.EVENT_TYPE.getPreferredName(), (ToXContent)this.eventType, params);
            }
            if (this.attachPayload != null) {
                builder.field(Fields.ATTACH_PAYLOAD.getPreferredName(), this.attachPayload);
            }
            if (this.account != null) {
                builder.field(Fields.ACCOUNT.getPreferredName(), this.account);
            }
            if (this.proxy != null) {
                this.proxy.toXContent(builder, params);
            }
            if (this.contexts != null) {
                builder.startArray(Fields.CONTEXTS.getPreferredName());
                for (IncidentEventContext.Template context : this.contexts) {
                    context.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder.endObject();
        }

        public static Template parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            TextTemplate incidentKey = null;
            TextTemplate description = null;
            TextTemplate client = null;
            TextTemplate clientUrl = null;
            TextTemplate eventType = null;
            String account = null;
            HttpProxy proxy = null;
            Boolean attachPayload = null;
            IncidentEventContext.Template[] contexts = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Fields.INCIDENT_KEY.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        incidentKey = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.INCIDENT_KEY.getPreferredName()});
                    }
                }
                if (Fields.DESCRIPTION.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        description = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.DESCRIPTION.getPreferredName()});
                    }
                }
                if (Fields.CLIENT.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        client = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT.getPreferredName()});
                    }
                }
                if (Fields.CLIENT_URL.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        clientUrl = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT_URL.getPreferredName()});
                    }
                }
                if (Fields.ACCOUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        account = parser.text();
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.CLIENT_URL.getPreferredName()});
                    }
                }
                if (Fields.PROXY.match(currentFieldName, parser.getDeprecationHandler())) {
                    proxy = HttpProxy.parse(parser);
                    continue;
                }
                if (Fields.EVENT_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        eventType = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{Fields.EVENT_TYPE.getPreferredName()});
                    }
                }
                if (Fields.ATTACH_PAYLOAD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        attachPayload = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}], expected a boolean value but found [{}] instead", new Object[]{Fields.ATTACH_PAYLOAD.getPreferredName(), token});
                }
                if (Fields.CONTEXTS.match(currentFieldName, parser.getDeprecationHandler()) || Fields.CONTEXT_DEPRECATED.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    ArrayList<IncidentEventContext.Template> list = new ArrayList<IncidentEventContext.Template>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        try {
                            list.add(IncidentEventContext.Template.parse(parser));
                        }
                        catch (ElasticsearchParseException e) {
                            throw new ElasticsearchParseException("could not parse pager duty event template. failed to parse field [{}]", new Object[]{parser.currentName()});
                        }
                    }
                    contexts = list.toArray(new IncidentEventContext.Template[list.size()]);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse pager duty event template. unexpected field [{}]", new Object[]{currentFieldName});
            }
            return new Template(description, eventType, incidentKey, client, clientUrl, account, attachPayload, contexts, proxy);
        }

        public static class Builder {
            final TextTemplate description;
            TextTemplate incidentKey;
            TextTemplate client;
            TextTemplate clientUrl;
            TextTemplate eventType;
            String account;
            HttpProxy proxy;
            Boolean attachPayload;
            List<IncidentEventContext.Template> contexts = new ArrayList<IncidentEventContext.Template>();

            public Builder(TextTemplate description) {
                this.description = description;
            }

            public Builder setIncidentKey(TextTemplate incidentKey) {
                this.incidentKey = incidentKey;
                return this;
            }

            public Builder setClient(TextTemplate client) {
                this.client = client;
                return this;
            }

            public Builder setClientUrl(TextTemplate clientUrl) {
                this.clientUrl = clientUrl;
                return this;
            }

            public Builder setEventType(TextTemplate eventType) {
                this.eventType = eventType;
                return this;
            }

            public Builder setAccount(String account) {
                this.account = account;
                return this;
            }

            public Builder setAttachPayload(Boolean attachPayload) {
                this.attachPayload = attachPayload;
                return this;
            }

            public Builder setProxy(HttpProxy proxy) {
                this.proxy = proxy;
                return this;
            }

            public Builder addContext(IncidentEventContext.Template context) {
                this.contexts.add(context);
                return this;
            }

            public Template build() {
                IncidentEventContext.Template[] contexts = this.contexts.isEmpty() ? null : this.contexts.toArray(new IncidentEventContext.Template[this.contexts.size()]);
                return new Template(this.description, this.eventType, this.incidentKey, this.client, this.clientUrl, this.account, this.attachPayload, contexts, this.proxy);
            }
        }
    }
}

