/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.pivot.AggregationConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class PivotConfig
implements Writeable,
ToXContentObject {
    private static final String NAME = "data_frame_transform_pivot";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(PivotConfig.class);
    private final GroupConfig groups;
    private final AggregationConfig aggregationConfig;
    private final Integer maxPageSearchSize;
    private static final ConstructingObjectParser<PivotConfig, Void> STRICT_PARSER = PivotConfig.createParser(false);
    private static final ConstructingObjectParser<PivotConfig, Void> LENIENT_PARSER = PivotConfig.createParser(true);

    private static ConstructingObjectParser<PivotConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            GroupConfig groups = (GroupConfig)args[0];
            AggregationConfig aggregationConfig = null;
            if (args[1] != null) {
                aggregationConfig = (AggregationConfig)args[1];
            }
            if (args[2] != null) {
                if (aggregationConfig != null) {
                    throw new IllegalArgumentException("Found two aggregation definitions: [aggs] and [aggregations]");
                }
                aggregationConfig = (AggregationConfig)args[2];
            }
            if (aggregationConfig == null) {
                throw new IllegalArgumentException("Required [aggregations]");
            }
            return new PivotConfig(groups, aggregationConfig, (Integer)args[3]);
        });
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> GroupConfig.fromXContent(p, lenient), TransformField.GROUP_BY);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AggregationConfig.fromXContent(p, lenient), TransformField.AGGREGATIONS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AggregationConfig.fromXContent(p, lenient), TransformField.AGGS);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), TransformField.MAX_PAGE_SEARCH_SIZE);
        return parser;
    }

    public PivotConfig(GroupConfig groups, AggregationConfig aggregationConfig, Integer maxPageSearchSize) {
        this.groups = ExceptionsHelper.requireNonNull(groups, TransformField.GROUP_BY.getPreferredName());
        this.aggregationConfig = ExceptionsHelper.requireNonNull(aggregationConfig, TransformField.AGGREGATIONS.getPreferredName());
        this.maxPageSearchSize = maxPageSearchSize;
        if (maxPageSearchSize != null) {
            deprecationLogger.deprecate(DeprecationCategory.API, TransformField.MAX_PAGE_SEARCH_SIZE.getPreferredName(), "[max_page_search_size] is deprecated inside pivot please use settings instead", new Object[0]);
        }
    }

    public PivotConfig(StreamInput in) throws IOException {
        this.groups = new GroupConfig(in);
        this.aggregationConfig = new AggregationConfig(in);
        this.maxPageSearchSize = in.readOptionalInt();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.GROUP_BY.getPreferredName(), (ToXContent)this.groups);
        builder.field(TransformField.AGGREGATIONS.getPreferredName(), (ToXContent)this.aggregationConfig);
        if (this.maxPageSearchSize != null) {
            builder.field(TransformField.MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
        }
        builder.endObject();
        return builder;
    }

    public void toCompositeAggXContent(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.field(CompositeAggregationBuilder.SOURCES_FIELD_NAME.getPreferredName());
        builder.startArray();
        for (Map.Entry<String, SingleGroupSource> groupBy : this.groups.getGroups().entrySet()) {
            builder.startObject();
            builder.startObject(groupBy.getKey());
            builder.field(groupBy.getValue().getType().value(), (ToXContent)groupBy.getValue());
            builder.endObject();
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.groups.writeTo(out);
        this.aggregationConfig.writeTo(out);
        out.writeOptionalInt(this.maxPageSearchSize);
    }

    public AggregationConfig getAggregationConfig() {
        return this.aggregationConfig;
    }

    public GroupConfig getGroupConfig() {
        return this.groups;
    }

    @Nullable
    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PivotConfig that = (PivotConfig)other;
        return Objects.equals(this.groups, that.groups) && Objects.equals(this.aggregationConfig, that.aggregationConfig) && Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.aggregationConfig, this.maxPageSearchSize);
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.maxPageSearchSize != null && (this.maxPageSearchSize < 10 || this.maxPageSearchSize > 10000)) {
            validationException = ValidateActions.addValidationError((String)("pivot.max_page_search_size [" + this.maxPageSearchSize + "] must be greater than 10 and less than 10,000"), (ActionRequestValidationException)validationException);
        }
        validationException = this.groups.validate(validationException);
        validationException = this.aggregationConfig.validate(validationException);
        ArrayList<String> usedNames = new ArrayList<String>();
        usedNames.addAll(this.groups.getUsedNames());
        usedNames.addAll(this.aggregationConfig.getUsedNames());
        for (String failure : PivotConfig.aggFieldValidation(usedNames)) {
            validationException = ValidateActions.addValidationError((String)failure, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public static PivotConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (PivotConfig)LENIENT_PARSER.apply(parser, null) : (PivotConfig)STRICT_PARSER.apply(parser, null);
    }

    static List<String> aggFieldValidation(List<String> usedNames) {
        if (usedNames == null || usedNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> validationFailures = new ArrayList<String>();
        usedNames.sort(String::compareTo);
        for (int i = 0; i < usedNames.size() - 1; ++i) {
            if (usedNames.get(i + 1).startsWith(usedNames.get(i) + ".")) {
                validationFailures.add("field [" + usedNames.get(i) + "] cannot be both an object and a field");
            }
            if (!usedNames.get(i + 1).equals(usedNames.get(i))) continue;
            validationFailures.add("duplicate field [" + usedNames.get(i) + "] detected");
        }
        for (String name : usedNames) {
            if (name.startsWith(".")) {
                validationFailures.add("field [" + name + "] must not start with '.'");
            }
            if (!name.endsWith(".")) continue;
            validationFailures.add("field [" + name + "] must not end with '.'");
        }
        return validationFailures;
    }
}

