/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;

public class PreviewTransformAction
extends ActionType<Response> {
    public static final PreviewTransformAction INSTANCE = new PreviewTransformAction();
    public static final String NAME = "cluster:admin/transform/preview";
    public static final String DUMMY_DEST_INDEX_FOR_PREVIEW = "unused-transform-preview-index";

    private PreviewTransformAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField PREVIEW = new ParseField("preview", new String[0]);
        public static final ParseField GENERATED_DEST_INDEX_SETTINGS = new ParseField("generated_dest_index", new String[0]);
        private final List<Map<String, Object>> docs;
        private final TransformDestIndexSettings generatedDestIndexSettings;
        private static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("data_frame_transform_preview", true, args -> {
            List docs = (List)args[0];
            TransformDestIndexSettings generatedDestIndex = (TransformDestIndexSettings)((Object)((Object)args[1]));
            return new Response(docs, generatedDestIndex);
        });

        public Response(List<Map<String, Object>> docs, TransformDestIndexSettings generatedDestIndexSettings) {
            this.docs = docs;
            this.generatedDestIndexSettings = generatedDestIndexSettings;
        }

        public Response(StreamInput in) throws IOException {
            int size = in.readInt();
            this.docs = new ArrayList<Map<String, Object>>(size);
            for (int i = 0; i < size; ++i) {
                this.docs.add(in.readMap());
            }
            if (in.getVersion().onOrAfter(Version.V_7_7_0)) {
                this.generatedDestIndexSettings = new TransformDestIndexSettings(in);
            } else if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
                Map objectMap = in.readMap();
                this.generatedDestIndexSettings = new TransformDestIndexSettings(objectMap, null, null);
            } else {
                this.generatedDestIndexSettings = new TransformDestIndexSettings(null, null, null);
            }
        }

        public List<Map<String, Object>> getDocs() {
            return this.docs;
        }

        public TransformDestIndexSettings getGeneratedDestIndexSettings() {
            return this.generatedDestIndexSettings;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.docs.size());
            for (Map<String, Object> doc : this.docs) {
                out.writeMapWithConsistentOrder(doc);
            }
            if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
                this.generatedDestIndexSettings.writeTo(out);
            } else if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                out.writeMap(this.generatedDestIndexSettings.getMappings());
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PREVIEW.getPreferredName(), this.docs);
            builder.field(GENERATED_DEST_INDEX_SETTINGS.getPreferredName(), (ToXContent)this.generatedDestIndexSettings);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(other.docs, this.docs) && Objects.equals((Object)other.generatedDestIndexSettings, (Object)this.generatedDestIndexSettings);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.docs, this.generatedDestIndexSettings});
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        public static Response fromXContent(XContentParser parser) throws IOException {
            return (Response)((Object)PARSER.parse(parser, null));
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), PREVIEW);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformDestIndexSettings.fromXContent(p), GENERATED_DEST_INDEX_SETTINGS);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private final TransformConfig config;

        public Request(TransformConfig config) {
            this.config = config;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            Map content = parser.map();
            HashMap<String, String> tempDestination = new HashMap<String, String>();
            tempDestination.put(DestConfig.INDEX.getPreferredName(), PreviewTransformAction.DUMMY_DEST_INDEX_FOR_PREVIEW);
            Object providedDestination = content.get(TransformField.DESTINATION.getPreferredName());
            if (providedDestination instanceof Map) {
                Map providedDestinationAsMap = (Map)providedDestination;
                tempDestination.putAll(providedDestinationAsMap);
            }
            content.put(TransformField.DESTINATION.getPreferredName(), tempDestination);
            content.putIfAbsent(TransformField.ID.getPreferredName(), "transform-preview");
            try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(content);){
                Request request;
                block13: {
                    XContentParser newParser = XContentType.JSON.xContent().createParser(parser.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                    try {
                        request = new Request(TransformConfig.fromXContent(newParser, null, false));
                        if (newParser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (newParser != null) {
                            try {
                                newParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    newParser.close();
                }
                return request;
            }
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = this.config.validate(validationException);
            validationException = SourceDestValidator.validateRequest(validationException, this.config.getDestination() != null ? this.config.getDestination().getIndex() : null);
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.config});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config);
        }
    }
}

