/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.history;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryItem;

public class SnapshotHistoryStore {
    private static final Logger logger = LogManager.getLogger(SnapshotHistoryStore.class);
    public static final String SLM_HISTORY_DATA_STREAM = ".slm-history-5";
    private final Client client;
    private final ClusterService clusterService;
    private final boolean slmHistoryEnabled;

    public SnapshotHistoryStore(Settings nodeSettings, Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.slmHistoryEnabled = (Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    public void putAsync(SnapshotHistoryItem item) {
        if (!this.slmHistoryEnabled) {
            logger.trace("not recording snapshot history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("about to index snapshot history item in data stream [{}]: [{}]", (Object)SLM_HISTORY_DATA_STREAM, (Object)item);
        Metadata metadata = this.clusterService.state().getMetadata();
        if (!metadata.dataStreams().containsKey(SLM_HISTORY_DATA_STREAM) && !metadata.templatesV2().containsKey(".slm-history")) {
            logger.error((Message)new ParameterizedMessage("failed to index snapshot history item, data stream [{}] and template [{}] don't exist", (Object)SLM_HISTORY_DATA_STREAM, (Object)".slm-history"));
            return;
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            item.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = new IndexRequest(SLM_HISTORY_DATA_STREAM).opType(DocWriteRequest.OpType.CREATE).source(builder);
            this.client.index(request, ActionListener.wrap(indexResponse -> logger.debug("successfully indexed snapshot history item with id [{}] in data stream [{}]: [{}]", (Object)indexResponse.getId(), (Object)SLM_HISTORY_DATA_STREAM, (Object)item), exception -> logger.error((Message)new ParameterizedMessage("failed to index snapshot history item in data stream [{}]: [{}]", (Object)SLM_HISTORY_DATA_STREAM, (Object)item), (Throwable)exception)));
        }
        catch (IOException exception2) {
            logger.error((Message)new ParameterizedMessage("failed to index snapshot history item in data stream [{}]: [{}]", (Object)SLM_HISTORY_DATA_STREAM, (Object)item), (Throwable)exception2);
        }
    }
}

