/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Map;

public class TokenInfo
implements Writeable,
ToXContentObject,
Comparable<TokenInfo> {
    private final String name;
    private final TokenSource source;

    private TokenInfo(String name, TokenSource source) {
        this.name = name;
        this.source = source;
    }

    public TokenInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.source = (TokenSource)in.readEnum(TokenSource.class);
    }

    public String getName() {
        return this.name;
    }

    public TokenSource getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInfo tokenInfo = (TokenInfo)o;
        return Objects.equals(this.name, tokenInfo.name) && this.source == tokenInfo.source;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.source});
    }

    public static TokenInfo indexToken(String name) {
        return new TokenInfo(name, TokenSource.INDEX);
    }

    public static TokenInfo fileToken(String name) {
        return new TokenInfo(name, TokenSource.FILE);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(this.name, Map.of());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeEnum((Enum)this.source);
    }

    @Override
    public int compareTo(TokenInfo o) {
        int score = this.source.compareTo(o.source);
        if (score == 0) {
            return this.name.compareTo(o.name);
        }
        return score;
    }

    public static enum TokenSource {
        INDEX,
        FILE;

    }
}

