/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OpenIdConnectPrepareAuthenticationResponse
extends ActionResponse
implements ToXContentObject {
    private String authenticationRequestUrl;
    private String state;
    private String nonce;
    private String realmName;

    public OpenIdConnectPrepareAuthenticationResponse(String authorizationEndpointUrl, String state, String nonce, String realmName) {
        this.authenticationRequestUrl = authorizationEndpointUrl;
        this.state = state;
        this.nonce = nonce;
        this.realmName = realmName;
    }

    public OpenIdConnectPrepareAuthenticationResponse(StreamInput in) throws IOException {
        super(in);
        this.authenticationRequestUrl = in.readString();
        this.state = in.readString();
        this.nonce = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_11_0)) {
            this.realmName = in.readString();
        }
    }

    public String getAuthenticationRequestUrl() {
        return this.authenticationRequestUrl;
    }

    public String getState() {
        return this.state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.authenticationRequestUrl);
        out.writeString(this.state);
        out.writeString(this.nonce);
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            out.writeString(this.realmName);
        }
    }

    public String toString() {
        return "{authenticationRequestUrl=" + this.authenticationRequestUrl + ", state=" + this.state + ", nonce=" + this.nonce + ", realmName" + this.realmName + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("redirect", this.authenticationRequestUrl);
        builder.field("state", this.state);
        builder.field("nonce", this.nonce);
        if (this.realmName != null) {
            builder.field("realm", this.realmName);
        }
        builder.endObject();
        return builder;
    }
}

