/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TargetMeanEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TargetMeanEncoding.class);
    public static final ParseField NAME = new ParseField("target_mean_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField TARGET_MAP = new ParseField("target_map", new String[0]);
    public static final ParseField DEFAULT_VALUE = new ParseField("default_value", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ConstructingObjectParser<TargetMeanEncoding, PreProcessor.PreProcessorParseContext> STRICT_PARSER = TargetMeanEncoding.createParser(false);
    private static final ConstructingObjectParser<TargetMeanEncoding, PreProcessor.PreProcessorParseContext> LENIENT_PARSER = TargetMeanEncoding.createParser(true);
    private final String field;
    private final String featureName;
    private final Map<String, Double> meanMap;
    private final double defaultValue;
    private final boolean custom;

    private static ConstructingObjectParser<TargetMeanEncoding, PreProcessor.PreProcessorParseContext> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, (a, c) -> new TargetMeanEncoding((String)a[0], (String)a[1], (Map)a[2], (Double)a[3], a[4] == null ? c.isCustomByDefault() : ((Boolean)a[4]).booleanValue()));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), TARGET_MAP);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), DEFAULT_VALUE);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
        return parser;
    }

    public static TargetMeanEncoding fromXContentStrict(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return (TargetMeanEncoding)STRICT_PARSER.apply(parser, (Object)(context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context));
    }

    public static TargetMeanEncoding fromXContentLenient(XContentParser parser, PreProcessor.PreProcessorParseContext context) {
        return (TargetMeanEncoding)LENIENT_PARSER.apply(parser, (Object)(context == null ? PreProcessor.PreProcessorParseContext.DEFAULT : context));
    }

    public TargetMeanEncoding(String field, String featureName, Map<String, Double> meanMap, Double defaultValue, Boolean custom) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.meanMap = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(meanMap, TARGET_MAP));
        this.defaultValue = ExceptionsHelper.requireNonNull(defaultValue, DEFAULT_VALUE);
        this.custom = custom == null ? false : custom;
    }

    public TargetMeanEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.featureName = in.readString();
        this.meanMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readDouble));
        this.defaultValue = in.readDouble();
        this.custom = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readBoolean() : false;
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getMeanMap() {
        return this.meanMap;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public Map<String, String> reverseLookup() {
        return Collections.singletonMap(this.featureName, this.field);
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    @Override
    public String getOutputFieldType(String outputField) {
        return NumberFieldMapper.NumberType.DOUBLE.typeName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public List<String> inputFields() {
        return Collections.singletonList(this.field);
    }

    @Override
    public List<String> outputFields() {
        return Collections.singletonList(this.featureName);
    }

    @Override
    public void process(Map<String, Object> fields) {
        Object value = fields.get(this.field);
        if (value == null) {
            return;
        }
        fields.put(this.featureName, this.meanMap.getOrDefault(value.toString(), this.defaultValue));
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.featureName);
        out.writeMap(this.meanMap, StreamOutput::writeString, StreamOutput::writeDouble);
        out.writeDouble(this.defaultValue);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.custom);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(TARGET_MAP.getPreferredName(), this.meanMap);
        builder.field(DEFAULT_VALUE.getPreferredName(), this.defaultValue);
        builder.field(CUSTOM.getPreferredName(), this.custom);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetMeanEncoding that = (TargetMeanEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.meanMap, that.meanMap) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.meanMap, this.defaultValue, this.custom);
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf((String)this.field);
        size += RamUsageEstimator.sizeOf((String)this.featureName);
        return size += RamUsageEstimator.sizeOfMap(this.meanMap, (long)0L);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

