/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.calendars;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Operator;
import org.elasticsearch.xpack.core.ml.job.config.RuleAction;
import org.elasticsearch.xpack.core.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.Intervals;

public class ScheduledEvent
implements ToXContentObject,
Writeable {
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField START_TIME = new ParseField("start_time", new String[0]);
    public static final ParseField END_TIME = new ParseField("end_time", new String[0]);
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField EVENT_ID = new ParseField("event_id", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("events", new String[0]);
    public static final String SCHEDULED_EVENT_TYPE = "scheduled_event";
    public static final String DOCUMENT_ID_PREFIX = "event_";
    public static final ObjectParser<Builder, Void> STRICT_PARSER = ScheduledEvent.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = ScheduledEvent.createParser(true);
    private final String description;
    private final Instant startTime;
    private final Instant endTime;
    private final String calendarId;
    private final String eventId;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(SCHEDULED_EVENT_TYPE, ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::description, DESCRIPTION);
        parser.declareField(Builder::startTime, p -> TimeUtils.parseTimeFieldToInstant(p, START_TIME.getPreferredName()), START_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::endTime, p -> TimeUtils.parseTimeFieldToInstant(p, END_TIME.getPreferredName()), END_TIME, ObjectParser.ValueType.VALUE);
        parser.declareString(Builder::calendarId, Calendar.ID);
        parser.declareString((builder, s) -> {}, TYPE);
        return parser;
    }

    public static String documentId(String eventId) {
        return DOCUMENT_ID_PREFIX + eventId;
    }

    ScheduledEvent(String description, Instant startTime, Instant endTime, String calendarId, @Nullable String eventId) {
        this.description = Objects.requireNonNull(description);
        this.startTime = Instant.ofEpochMilli(Objects.requireNonNull(startTime).toEpochMilli());
        this.endTime = Instant.ofEpochMilli(Objects.requireNonNull(endTime).toEpochMilli());
        this.calendarId = Objects.requireNonNull(calendarId);
        this.eventId = eventId;
    }

    public ScheduledEvent(StreamInput in) throws IOException {
        this.description = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.startTime = in.readInstant();
            this.endTime = in.readInstant();
        } else {
            this.startTime = Instant.ofEpochMilli(in.readVLong());
            this.endTime = Instant.ofEpochMilli(in.readVLong());
        }
        this.calendarId = in.readString();
        this.eventId = in.readOptionalString();
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public DetectionRule toDetectionRule(TimeValue bucketSpan) {
        ArrayList<RuleCondition> conditions = new ArrayList<RuleCondition>();
        long bucketSpanSecs = bucketSpan.getSeconds();
        long bucketStartTime = Intervals.alignToFloor(this.getStartTime().getEpochSecond(), bucketSpanSecs);
        conditions.add(RuleCondition.createTime(Operator.GTE, bucketStartTime));
        long bucketEndTime = Intervals.alignToCeil(this.getEndTime().getEpochSecond(), bucketSpanSecs);
        conditions.add(RuleCondition.createTime(Operator.LT, bucketEndTime));
        DetectionRule.Builder builder = new DetectionRule.Builder(conditions);
        builder.setActions(RuleAction.SKIP_RESULT, RuleAction.SKIP_MODEL_UPDATE);
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.description);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeInstant(this.startTime);
            out.writeInstant(this.endTime);
        } else {
            out.writeVLong(this.startTime.toEpochMilli());
            out.writeVLong(this.endTime.toEpochMilli());
        }
        out.writeString(this.calendarId);
        out.writeOptionalString(this.eventId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DESCRIPTION.getPreferredName(), this.description);
        builder.timeField(START_TIME.getPreferredName(), START_TIME.getPreferredName() + "_string", this.startTime.toEpochMilli());
        builder.timeField(END_TIME.getPreferredName(), END_TIME.getPreferredName() + "_string", this.endTime.toEpochMilli());
        builder.field(Calendar.ID.getPreferredName(), this.calendarId);
        if (this.eventId != null) {
            builder.field(EVENT_ID.getPreferredName(), this.eventId);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(TYPE.getPreferredName(), SCHEDULED_EVENT_TYPE);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScheduledEvent)) {
            return false;
        }
        ScheduledEvent other = (ScheduledEvent)obj;
        return this.description.equals(other.description) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && this.calendarId.equals(other.calendarId);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.startTime, this.endTime, this.calendarId);
    }

    public static class Builder {
        private String description;
        private Instant startTime;
        private Instant endTime;
        private String calendarId;
        private String eventId;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = Instant.ofEpochMilli(Objects.requireNonNull(startTime, START_TIME.getPreferredName()).toEpochMilli());
            return this;
        }

        public Builder endTime(Instant endTime) {
            this.endTime = Instant.ofEpochMilli(Objects.requireNonNull(endTime, END_TIME.getPreferredName()).toEpochMilli());
            return this;
        }

        public Builder calendarId(String calendarId) {
            this.calendarId = calendarId;
            return this;
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public ScheduledEvent build() {
            if (this.description == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Field [{0}] cannot be null", DESCRIPTION.getPreferredName()), new Object[0]);
            }
            if (this.startTime == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Field [{0}] cannot be null", START_TIME.getPreferredName()), new Object[0]);
            }
            if (this.endTime == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Field [{0}] cannot be null", END_TIME.getPreferredName()), new Object[0]);
            }
            if (this.calendarId == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Field [{0}] cannot be null", Calendar.ID.getPreferredName()), new Object[0]);
            }
            if (!this.startTime.isBefore(this.endTime)) {
                throw ExceptionsHelper.badRequestException("Event start time [" + this.startTime + "] must come before end time [" + this.endTime + "]", new Object[0]);
            }
            ScheduledEvent event = new ScheduledEvent(this.description, this.startTime, this.endTime, this.calendarId, this.eventId);
            return event;
        }
    }
}

