/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;

public class PinnedQueryBuilder
extends AbstractQueryBuilder<PinnedQueryBuilder> {
    public static final String NAME = "pinned";
    protected final QueryBuilder organicQuery;
    protected final List<String> ids;
    protected static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    protected static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);

    public String getWriteableName() {
        return NAME;
    }

    public PinnedQueryBuilder(QueryBuilder organicQuery, String ... ids) {
        if (organicQuery == null) {
            throw new IllegalArgumentException("[pinned] organicQuery cannot be null");
        }
        this.organicQuery = organicQuery;
        if (ids == null) {
            throw new IllegalArgumentException("[pinned] ids cannot be null");
        }
        this.ids = new ArrayList<String>();
        Collections.addAll(this.ids, ids);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.ids);
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    public List<String> ids() {
        return Collections.unmodifiableList(this.ids);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.organicQuery != null) {
            builder.field(ORGANIC_QUERY_FIELD.getPreferredName());
            this.organicQuery.toXContent(builder, params);
        }
        builder.startArray(IDS_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        throw new UnsupportedOperationException("Client side-only class for use in HLRC");
    }

    protected int doHashCode() {
        return Objects.hash(this.ids, this.organicQuery);
    }

    protected boolean doEquals(PinnedQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.organicQuery, other.organicQuery) && this.boost == other.boost;
    }
}

