/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;

public class LifecyclePolicyUtils {
    private LifecyclePolicyUtils() {
    }

    public static LifecyclePolicy loadPolicy(String name, String resource, NamedXContentRegistry xContentRegistry) {
        LifecyclePolicy lifecyclePolicy;
        block8: {
            BytesReference source = LifecyclePolicyUtils.load(resource);
            LifecyclePolicyUtils.validate(source);
            XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, LoggingDeprecationHandler.THROW_UNSUPPORTED_OPERATION, source.utf8ToString());
            try {
                LifecyclePolicy policy = LifecyclePolicy.parse(parser, name);
                policy.validate();
                lifecyclePolicy = policy;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("unable to load policy [" + name + "] from [" + resource + "]", e);
                }
            }
            parser.close();
        }
        return lifecyclePolicy;
    }

    private static BytesReference load(String name) throws IOException {
        try (InputStream is = LifecyclePolicyUtils.class.getResourceAsStream(name);){
            BytesArray bytesArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Streams.copy((InputStream)is, (OutputStream)out);
                bytesArray = new BytesArray(out.toByteArray());
            }
            return bytesArray;
        }
    }

    private static void validate(BytesReference source) {
        if (source == null) {
            throw new ElasticsearchParseException("policy must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((BytesReference)source, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("policy must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("invalid policy", (Throwable)e, new Object[0]);
        }
    }

    public static ItemUsage calculateUsage(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState state, String policyName) {
        List indices = StreamSupport.stream(state.metadata().indices().values().spliterator(), false).map(cursor -> (IndexMetadata)cursor.value).filter(indexMetadata -> policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()))).map(indexMetadata -> indexMetadata.getIndex().getName()).collect(Collectors.toList());
        List allDataStreams = indexNameExpressionResolver.dataStreamNames(state, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN, new String[0]);
        List dataStreams = allDataStreams.stream().filter(dsName -> {
            String indexTemplate = MetadataIndexTemplateService.findV2Template((Metadata)state.metadata(), (String)dsName, (boolean)false);
            if (indexTemplate != null) {
                Settings settings = MetadataIndexTemplateService.resolveSettings((Metadata)state.metadata(), (String)indexTemplate);
                return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
            }
            return false;
        }).collect(Collectors.toList());
        List composableTemplates = state.metadata().templatesV2().keySet().stream().filter(templateName -> {
            Settings settings = MetadataIndexTemplateService.resolveSettings((Metadata)state.metadata(), (String)templateName);
            return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
        }).collect(Collectors.toList());
        return new ItemUsage(indices, dataStreams, composableTemplates);
    }
}

