/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.frozen;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;

final class RewriteCachingDirectoryReader
extends DirectoryReader {
    RewriteCachingDirectoryReader(Directory directory, List<LeafReaderContext> segmentReaders, Comparator<LeafReader> leafSorter) throws IOException {
        super(directory, RewriteCachingDirectoryReader.wrap(segmentReaders), leafSorter);
    }

    private static LeafReader[] wrap(List<LeafReaderContext> readers) throws IOException {
        LeafReader[] wrapped = new LeafReader[readers.size()];
        int i = 0;
        for (LeafReaderContext ctx : readers) {
            RewriteCachingLeafReader wrap = new RewriteCachingLeafReader(ctx.reader());
            wrapped[i++] = wrap;
        }
        return wrapped;
    }

    protected DirectoryReader doOpenIfChanged() {
        throw new UnsupportedOperationException();
    }

    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw new UnsupportedOperationException();
    }

    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw new UnsupportedOperationException();
    }

    public long getVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrent() {
        throw new UnsupportedOperationException();
    }

    public IndexCommit getIndexCommit() {
        throw new UnsupportedOperationException();
    }

    protected void doClose() {
        throw new UnsupportedOperationException();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }

    private static final class RewriteCachingLeafReader
    extends LeafReader {
        private final int maxDoc;
        private final int numDocs;
        private final Map<String, PointValues> pointValuesMap;
        private final FieldInfos fieldInfos;

        private RewriteCachingLeafReader(LeafReader original) throws IOException {
            this.maxDoc = original.maxDoc();
            this.numDocs = original.numDocs();
            this.fieldInfos = original.getFieldInfos();
            HashMap<String, PointValues> valuesMap = new HashMap<String, PointValues>();
            for (FieldInfo info : this.fieldInfos) {
                PointValues pointValues;
                if (info.getPointIndexDimensionCount() == 0 || (pointValues = original.getPointValues(info.name)) == null) continue;
                final byte[] minPackedValue = pointValues.getMinPackedValue();
                final byte[] maxPackedValue = pointValues.getMaxPackedValue();
                final int numIndexDimensions = pointValues.getNumIndexDimensions();
                final int bytesPerDimension = pointValues.getBytesPerDimension();
                final int numDimensions = pointValues.getNumDimensions();
                final long size = pointValues.size();
                final int docCount = pointValues.getDocCount();
                valuesMap.put(info.name, new PointValues(){

                    public void intersect(PointValues.IntersectVisitor visitor) {
                        throw new UnsupportedOperationException();
                    }

                    public long estimatePointCount(PointValues.IntersectVisitor visitor) {
                        throw new UnsupportedOperationException();
                    }

                    public byte[] getMinPackedValue() {
                        return minPackedValue;
                    }

                    public byte[] getMaxPackedValue() {
                        return maxPackedValue;
                    }

                    public int getNumDimensions() {
                        return numDimensions;
                    }

                    public int getNumIndexDimensions() {
                        return numIndexDimensions;
                    }

                    public int getBytesPerDimension() {
                        return bytesPerDimension;
                    }

                    public long size() {
                        return size;
                    }

                    public int getDocCount() {
                        return docCount;
                    }
                });
            }
            this.pointValuesMap = valuesMap;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            throw new UnsupportedOperationException();
        }

        public Terms terms(String field) {
            throw new UnsupportedOperationException();
        }

        public NumericDocValues getNumericDocValues(String field) {
            throw new UnsupportedOperationException();
        }

        public BinaryDocValues getBinaryDocValues(String field) {
            throw new UnsupportedOperationException();
        }

        public SortedDocValues getSortedDocValues(String field) {
            throw new UnsupportedOperationException();
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) {
            throw new UnsupportedOperationException();
        }

        public SortedSetDocValues getSortedSetDocValues(String field) {
            throw new UnsupportedOperationException();
        }

        public NumericDocValues getNormValues(String field) {
            throw new UnsupportedOperationException();
        }

        public FieldInfos getFieldInfos() {
            return this.fieldInfos;
        }

        public Bits getLiveDocs() {
            throw new UnsupportedOperationException();
        }

        public PointValues getPointValues(String field) {
            return this.pointValuesMap.get(field);
        }

        public void checkIntegrity() {
        }

        public LeafMetaData getMetaData() {
            throw new UnsupportedOperationException();
        }

        public Fields getTermVectors(int docID) {
            throw new UnsupportedOperationException();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public int maxDoc() {
            return this.maxDoc;
        }

        public void document(int docID, StoredFieldVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        protected void doClose() {
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

