/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;

public class AutomatonQueryOnBinaryDv
extends Query {
    private final String field;
    private final String matchPattern;
    private final ByteRunAutomaton bytesMatcher;

    public AutomatonQueryOnBinaryDv(String field, String matchPattern, Automaton automaton) {
        this.field = field;
        this.matchPattern = matchPattern;
        this.bytesMatcher = new ByteRunAutomaton(automaton);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final ByteArrayDataInput badi = new ByteArrayDataInput();
                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)AutomatonQueryOnBinaryDv.this.field);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        BytesRef arrayOfValues = values.binaryValue();
                        badi.reset(arrayOfValues.bytes);
                        badi.setPosition(arrayOfValues.offset);
                        int size = badi.readVInt();
                        for (int i = 0; i < size; ++i) {
                            int valLength = badi.readVInt();
                            if (AutomatonQueryOnBinaryDv.this.bytesMatcher.run(arrayOfValues.bytes, badi.getPosition(), valLength)) {
                                return true;
                            }
                            badi.skipBytes((long)valLength);
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String toString(String field) {
        return field + ":" + this.matchPattern;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AutomatonQueryOnBinaryDv other = (AutomatonQueryOnBinaryDv)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.matchPattern, other.matchPattern) && Objects.equals(this.bytesMatcher, other.bytesMatcher);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.matchPattern, this.bytesMatcher);
    }
}

