/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class Transports
extends Enum<Transports> {
    public static final String TEST_MOCK_TRANSPORT_THREAD_PREFIX = "__mock_network_thread";
    private static final /* synthetic */ Transports[] $VALUES;

    public static Transports[] values() {
        return (Transports[])$VALUES.clone();
    }

    public static Transports valueOf(String name) {
        return Enum.valueOf(Transports.class, name);
    }

    public static boolean isTransportThread(Thread t) {
        String threadName = t.getName();
        for (String s : Arrays.asList("http_server_worker", "transport_worker", TEST_MOCK_TRANSPORT_THREAD_PREFIX)) {
            if (!threadName.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean assertTransportThread() {
        Thread t = Thread.currentThread();
        assert (Transports.isTransportThread(t)) : "Expected transport thread but got [" + t + "]";
        return true;
    }

    public static boolean assertNotTransportThread(String reason) {
        Thread t = Thread.currentThread();
        assert (!Transports.isTransportThread(t)) : "Expected current thread [" + t + "] to not be a transport thread. Reason: [" + reason + "]";
        return true;
    }

    public static boolean assertDefaultThreadContext(ThreadContext threadContext) {
        assert (threadContext.getRequestHeadersOnly().isEmpty() || threadContext.getRequestHeadersOnly().size() == 1 && threadContext.getRequestHeadersOnly().containsKey("X-Opaque-Id")) : "expected empty context but was " + threadContext.getRequestHeadersOnly() + " on " + Thread.currentThread().getName();
        return true;
    }

    private static /* synthetic */ Transports[] $values() {
        return new Transports[0];
    }

    static {
        $VALUES = Transports.$values();
    }
}

