/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.RawTaskStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public final class TaskInfo
implements Writeable,
ToXContentFragment {
    static final String INCLUDE_CANCELLED_PARAM = "include_cancelled";
    private final TaskId taskId;
    private final String type;
    private final String action;
    private final String description;
    private final long startTime;
    private final long runningTimeNanos;
    private final Task.Status status;
    private final boolean cancellable;
    private final boolean cancelled;
    private final TaskId parentTaskId;
    private final Map<String, String> headers;
    public static final ConstructingObjectParser<TaskInfo, Void> PARSER = new ConstructingObjectParser("task_info", true, a -> {
        Map<String, String> headers;
        int i = 0;
        TaskId id = new TaskId((String)a[i++], (Long)a[i++]);
        String type = (String)a[i++];
        String action = (String)a[i++];
        String description = (String)a[i++];
        BytesReference statusBytes = (BytesReference)a[i++];
        long startTime = (Long)a[i++];
        long runningTimeNanos = (Long)a[i++];
        boolean cancellable = (Boolean)a[i++];
        boolean cancelled = a[i++] == Boolean.TRUE;
        String parentTaskIdString = (String)a[i++];
        if ((headers = (Map<String, String>)a[i++]) == null) {
            headers = Collections.emptyMap();
        }
        RawTaskStatus status = statusBytes == null ? null : new RawTaskStatus(statusBytes);
        TaskId parentTaskId = parentTaskIdString == null ? TaskId.EMPTY_TASK_ID : new TaskId(parentTaskIdString);
        return new TaskInfo(id, type, action, description, status, startTime, runningTimeNanos, cancellable, cancelled, parentTaskId, headers);
    });

    public TaskInfo(TaskId taskId, String type, String action, String description, Task.Status status, long startTime, long runningTimeNanos, boolean cancellable, boolean cancelled, TaskId parentTaskId, Map<String, String> headers) {
        assert (cancellable || !cancelled) : "uncancellable task cannot be cancelled";
        this.taskId = taskId;
        this.type = type;
        this.action = action;
        this.description = description;
        this.status = status;
        this.startTime = startTime;
        this.runningTimeNanos = runningTimeNanos;
        this.cancellable = cancellable;
        this.cancelled = cancelled;
        this.parentTaskId = parentTaskId;
        this.headers = headers;
    }

    public TaskInfo(StreamInput in) throws IOException {
        this.taskId = TaskId.readFromStream(in);
        this.type = in.readString();
        this.action = in.readString();
        this.description = in.readOptionalString();
        this.status = in.readOptionalNamedWriteable(Task.Status.class);
        this.startTime = in.readLong();
        this.runningTimeNanos = in.readLong();
        this.cancellable = in.readBoolean();
        this.cancelled = in.getVersion().onOrAfter(Version.V_7_14_0) ? in.readBoolean() : false;
        assert (this.cancellable || !this.cancelled) : "uncancellable task cannot be cancelled";
        this.parentTaskId = TaskId.readFromStream(in);
        this.headers = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readMap(StreamInput::readString, StreamInput::readString) : Collections.emptyMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.taskId.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.action);
        out.writeOptionalString(this.description);
        out.writeOptionalNamedWriteable(this.status);
        out.writeLong(this.startTime);
        out.writeLong(this.runningTimeNanos);
        out.writeBoolean(this.cancellable);
        if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
            out.writeBoolean(this.cancelled);
        }
        this.parentTaskId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public long getId() {
        return this.taskId.getId();
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public Task.Status getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRunningTimeNanos() {
        return this.runningTimeNanos;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public TaskId getParentTaskId() {
        return this.parentTaskId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("node", this.taskId.getNodeId());
        builder.field("id", this.taskId.getId());
        builder.field("type", this.type);
        builder.field("action", this.action);
        if (this.status != null) {
            builder.field("status", (ToXContent)this.status, params);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        builder.timeField("start_time_in_millis", "start_time", this.startTime);
        if (builder.humanReadable()) {
            builder.field("running_time", new TimeValue(this.runningTimeNanos, TimeUnit.NANOSECONDS).toString());
        }
        builder.field("running_time_in_nanos", this.runningTimeNanos);
        builder.field("cancellable", this.cancellable);
        if (params.paramAsBoolean(INCLUDE_CANCELLED_PARAM, true) && this.cancellable) {
            builder.field("cancelled", this.cancelled);
        }
        if (this.parentTaskId.isSet()) {
            builder.field("parent_task_id", this.parentTaskId.toString());
        }
        builder.startObject("headers");
        for (Map.Entry<String, String> attribute : this.headers.entrySet()) {
            builder.field(attribute.getKey(), attribute.getValue());
        }
        builder.endObject();
        return builder;
    }

    public static TaskInfo fromXContent(XContentParser parser) {
        return (TaskInfo)PARSER.apply(parser, null);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskInfo.class) {
            return false;
        }
        TaskInfo other = (TaskInfo)obj;
        return Objects.equals(this.taskId, other.taskId) && Objects.equals(this.type, other.type) && Objects.equals(this.action, other.action) && Objects.equals(this.description, other.description) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.runningTimeNanos, other.runningTimeNanos) && Objects.equals(this.parentTaskId, other.parentTaskId) && Objects.equals(this.cancellable, other.cancellable) && Objects.equals(this.cancelled, other.cancelled) && Objects.equals(this.status, other.status) && Objects.equals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.type, this.action, this.description, this.startTime, this.runningTimeNanos, this.parentTaskId, this.cancellable, this.cancelled, this.status, this.headers);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("action", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
        ObjectParserHelper<TaskInfo, Void> parserHelper = new ObjectParserHelper<TaskInfo, Void>();
        parserHelper.declareRawObject((AbstractObjectParser<TaskInfo, Void>)PARSER, ConstructingObjectParser.optionalConstructorArg(), new ParseField("status", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("start_time_in_millis", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("running_time_in_nanos", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("cancellable", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("cancelled", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("parent_task_id", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), new ParseField("headers", new String[0]));
    }
}

