/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class AbstractAggregationBuilder<AB extends AbstractAggregationBuilder<AB>>
extends AggregationBuilder {
    protected Map<String, Object> metadata;

    public AbstractAggregationBuilder(String name) {
        super(name);
    }

    protected AbstractAggregationBuilder(AbstractAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder);
        this.metadata = metadata;
    }

    protected AbstractAggregationBuilder(StreamInput in) throws IOException {
        super(in.readString());
        this.factoriesBuilder = new AggregatorFactories.Builder(in);
        this.metadata = in.readMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.factoriesBuilder.writeTo(out);
        out.writeMap(this.metadata);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public AB subAggregation(AggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregation(PipelineAggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addPipelineAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregations(AggregatorFactories.Builder subFactories) {
        if (subFactories == null) {
            throw new IllegalArgumentException("[subFactories] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder = subFactories;
        return (AB)this;
    }

    public AB setMetadata(Map<String, Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("[metadata] must not be null: [" + this.name + "]");
        }
        this.metadata = metadata;
        return (AB)this;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.metadata);
    }

    @Override
    public final String getWriteableName() {
        return this.getType();
    }

    @Override
    public final AggregatorFactory build(AggregationContext context, AggregatorFactory parent) throws IOException {
        AggregatorFactory factory = this.doBuild(context, parent, this.factoriesBuilder);
        context.getUsageService().incAggregationUsage(this.getType(), factory.getStatsSubtype());
        return factory;
    }

    protected abstract AggregatorFactory doBuild(AggregationContext var1, AggregatorFactory var2, AggregatorFactories.Builder var3) throws IOException;

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.metadata != null) {
            builder.field("meta", this.metadata);
        }
        builder.field(this.getType());
        this.internalXContent(builder, params);
        if (this.factoriesBuilder != null && this.factoriesBuilder.count() > 0) {
            builder.field("aggregations");
            this.factoriesBuilder.toXContent(builder, params);
        }
        return builder.endObject();
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.factoriesBuilder, this.metadata, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAggregationBuilder other = (AbstractAggregationBuilder)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.factoriesBuilder, other.factoriesBuilder);
    }
}

