/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.cache.request.RequestCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class NodeIndicesStats
implements Writeable,
ToXContentFragment {
    private final CommonStats stats;
    private final Map<Index, List<IndexShardStats>> statsByShard;

    public NodeIndicesStats(StreamInput in) throws IOException {
        this.stats = new CommonStats(in);
        boolean hasStatsByShard = in.getVersion().onOrAfter(Version.V_7_13_0) ? true : in.readBoolean();
        this.statsByShard = new HashMap<Index, List<IndexShardStats>>();
        if (hasStatsByShard) {
            int entries = in.readVInt();
            for (int i = 0; i < entries; ++i) {
                Index index = new Index(in);
                int indexShardListSize = in.readVInt();
                ArrayList<IndexShardStats> indexShardStats = new ArrayList<IndexShardStats>(indexShardListSize);
                for (int j = 0; j < indexShardListSize; ++j) {
                    indexShardStats.add(new IndexShardStats(in));
                }
                this.statsByShard.put(index, indexShardStats);
            }
        }
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, List<IndexShardStats>> statsByShard) {
        this.statsByShard = Objects.requireNonNull(statsByShard);
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
    }

    @Nullable
    public StoreStats getStore() {
        return this.stats.getStore();
    }

    @Nullable
    public DocsStats getDocs() {
        return this.stats.getDocs();
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.stats.getIndexing();
    }

    @Nullable
    public GetStats getGet() {
        return this.stats.getGet();
    }

    @Nullable
    public SearchStats getSearch() {
        return this.stats.getSearch();
    }

    @Nullable
    public MergeStats getMerge() {
        return this.stats.getMerge();
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.stats.getRefresh();
    }

    @Nullable
    public FlushStats getFlush() {
        return this.stats.getFlush();
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.stats.getWarmer();
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.stats.getFieldData();
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.stats.getQueryCache();
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.stats.getRequestCache();
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.stats.getCompletion();
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.stats.getSegments();
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.stats.getTranslog();
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.stats.getRecoveryStats();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        if (out.getVersion().before(Version.V_7_13_0)) {
            out.writeBoolean(true);
        }
        out.writeVInt(this.statsByShard.size());
        for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
            entry.getKey().writeTo(out);
            out.writeVInt(entry.getValue().size());
            for (IndexShardStats indexShardStats : entry.getValue()) {
                indexShardStats.writeTo(out);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", "node");
        boolean bl = isLevelValid = "indices".equalsIgnoreCase(level) || "node".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [indices] or [node] or [shards] but was [" + level + "]");
        }
        builder.startObject("indices");
        this.stats.toXContent(builder, params);
        if ("indices".equals(level)) {
            Map<Index, CommonStats> indexStats = this.createStatsByIndex();
            builder.startObject("indices");
            for (Map.Entry<Index, CommonStats> entry : indexStats.entrySet()) {
                builder.startObject(entry.getKey().getName());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        } else if ("shards".equals(level)) {
            builder.startObject("shards");
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                builder.startArray(entry.getKey().getName());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    builder.startObject().startObject(String.valueOf(indexShardStats.getShardId().getId()));
                    for (ShardStats shardStats : indexShardStats.getShards()) {
                        shardStats.toXContent(builder, params);
                    }
                    builder.endObject().endObject();
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private Map<Index, CommonStats> createStatsByIndex() {
        HashMap<Index, CommonStats> statsMap = new HashMap<Index, CommonStats>();
        for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
            if (!statsMap.containsKey(entry.getKey())) {
                statsMap.put(entry.getKey(), new CommonStats());
            }
            for (IndexShardStats indexShardStats : entry.getValue()) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    ((CommonStats)statsMap.get(entry.getKey())).add(shardStats.getStats());
                }
            }
        }
        return statsMap;
    }

    public List<IndexShardStats> getShardStats(Index index) {
        return this.statsByShard.get(index);
    }

    static final class Fields {
        static final String INDICES = "indices";

        Fields() {
        }
    }
}

