/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Iterators {
    public static <T> Iterator<T> single(final T element) {
        return new Iterator<T>(){
            private T value;
            {
                this.value = Objects.requireNonNull(element);
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public T next() {
                Object res = this.value;
                this.value = null;
                return res;
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            throw new NullPointerException("iterators");
        }
        return new ConcatenatedIterator<T>(iterators);
    }

    static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T>[] iterators;
        private int index = 0;

        ConcatenatedIterator(Iterator<? extends T> ... iterators) {
            if (iterators == null) {
                throw new NullPointerException("iterators");
            }
            for (int i = 0; i < iterators.length; ++i) {
                if (iterators[i] != null) continue;
                throw new NullPointerException("iterators[" + i + "]");
            }
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            while (this.index < this.iterators.length && !(hasNext = this.iterators[this.index].hasNext())) {
                ++this.index;
            }
            return hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterators[this.index].next();
        }
    }
}

