/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ToString;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveWildcardEquals;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveWildcardNotEquals;
import org.elasticsearch.xpack.eql.plan.logical.Join;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.eql.plan.logical.LimitWithOffset;
import org.elasticsearch.xpack.eql.plan.physical.LocalRelation;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.eql.util.MathUtils;
import org.elasticsearch.xpack.eql.util.StringUtils;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Optimizer
extends RuleExecutor<LogicalPlan> {
    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : (LogicalPlan)this.execute((Node)verified);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch substitutions = new RuleExecutor.Batch((RuleExecutor)this, "Substitution", RuleExecutor.Limiter.ONCE, new Rule[]{new ReplaceWildcards(), new OptimizerRules.ReplaceSurrogateFunction(), new ReplaceRegexMatch(), new ReplaceNullChecks()});
        RuleExecutor.Batch operators = new RuleExecutor.Batch((RuleExecutor)this, "Operator Optimization", new Rule[]{new OptimizerRules.ConstantFolding(), new OptimizerRules.BooleanSimplification(), new OptimizerRules.LiteralsOnTheRight(), new OptimizerRules.BinaryComparisonSimplification(), new OptimizerRules.BooleanFunctionEqualsElimination(), new OptimizerRules.PropagateEquals(), new OptimizerRules.PropagateNullable(), new OptimizerRules.CombineBinaryComparisons(), new OptimizerRules.CombineDisjunctionsToIn(), new OptimizerRules.SimplifyComparisonsArithmetics(DataTypes::areCompatible), new PruneFilters(), new OptimizerRules.PruneLiteralsInOrderBy(), new PruneCast(), new CombineLimits(), new OptimizerRules.PushDownAndCombineFilters()});
        RuleExecutor.Batch constraints = new RuleExecutor.Batch((RuleExecutor)this, "Infer constraints", RuleExecutor.Limiter.ONCE, new Rule[]{new PropagateJoinKeyConstraints()});
        RuleExecutor.Batch ordering = new RuleExecutor.Batch((RuleExecutor)this, "Implicit Order", new Rule[]{new SortByLimit(), new PushDownOrderBy()});
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Skip Elasticsearch", new Rule[]{new SkipEmptyFilter(), new SkipEmptyJoin(), new SkipQueryOnLimitZero()});
        RuleExecutor.Batch label = new RuleExecutor.Batch((RuleExecutor)this, "Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(substitutions, operators, constraints, operators, ordering, local, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), plan.output());
    }

    private static class ReplaceWildcards
    extends OptimizerRules.OptimizerRule<Filter> {
        private ReplaceWildcards() {
        }

        protected LogicalPlan rule(Filter filter) {
            return (LogicalPlan)filter.transformExpressionsUp(InsensitiveBinaryComparison.class, cmp -> {
                InsensitiveBinaryComparison result = cmp;
                if (cmp instanceof InsensitiveWildcardEquals || cmp instanceof InsensitiveWildcardNotEquals) {
                    Expression target = null;
                    String wildString = null;
                    if (ReplaceWildcards.isWildcard(cmp.right())) {
                        wildString = (String)cmp.right().fold();
                        target = cmp.left();
                    }
                    if (target != null) {
                        Like like = new Like(cmp.source(), target, StringUtils.toLikePattern(wildString), true);
                        if (cmp instanceof InsensitiveWildcardNotEquals) {
                            like = new Not(cmp.source(), (Expression)like);
                        }
                        result = like;
                    }
                }
                return result;
            });
        }

        private static boolean isWildcard(Expression expr) {
            Object value;
            if (expr instanceof Literal && (value = expr.fold()) instanceof String) {
                String string = (String)value;
                return string.contains("*") || string.contains("?");
            }
            return false;
        }
    }

    static class ReplaceRegexMatch
    extends OptimizerRules.ReplaceRegexMatch {
        ReplaceRegexMatch() {
        }

        protected Expression regexToEquals(RegexMatch<?> regexMatch, Literal literal) {
            return regexMatch.caseInsensitive() ? new InsensitiveEquals(regexMatch.source(), regexMatch.field(), (Expression)literal, null) : new Equals(regexMatch.source(), regexMatch.field(), (Expression)literal);
        }
    }

    private static class ReplaceNullChecks
    extends OptimizerRules.OptimizerRule<Filter> {
        private ReplaceNullChecks() {
        }

        protected LogicalPlan rule(Filter filter) {
            return (LogicalPlan)filter.transformExpressionsUp(BinaryComparison.class, cmp -> {
                Object result = cmp;
                if (cmp instanceof Equals || cmp instanceof NotEquals) {
                    Expression comparableToNull = null;
                    if (cmp.right().foldable() && cmp.right().fold() == null) {
                        comparableToNull = cmp.left();
                    } else if (cmp.left().foldable() && cmp.left().fold() == null) {
                        comparableToNull = cmp.right();
                    }
                    if (comparableToNull != null) {
                        result = cmp instanceof Equals ? new IsNull(cmp.source(), comparableToNull) : new IsNotNull(cmp.source(), comparableToNull);
                    }
                }
                return result;
            });
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return Optimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static class PruneCast
    extends OptimizerRules.PruneCast<ToString> {
        PruneCast() {
            super(ToString.class);
        }

        protected Expression maybePruneCast(ToString cast) {
            return cast.dataType().equals((Object)cast.value().dataType()) ? cast.value() : cast;
        }
    }

    static final class CombineLimits
    extends OptimizerRules.OptimizerRule<LimitWithOffset> {
        CombineLimits() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(LimitWithOffset limit) {
            if (!(limit.child() instanceof LimitWithOffset)) {
                return limit;
            }
            LimitWithOffset primary = (LimitWithOffset)limit.child();
            int primaryLimit = (Integer)primary.limit().fold();
            int primaryOffset = primary.offset();
            int sign = Integer.signum(primaryLimit);
            int secondaryLimit = (Integer)limit.limit().fold();
            if (limit.offset() != 0) {
                throw new EqlIllegalArgumentException("Limits with different offset not implemented yet");
            }
            if (primaryLimit > 0 && secondaryLimit > 0) {
                primaryLimit = Math.min(primaryLimit, secondaryLimit);
            } else if (primaryLimit < 0 && secondaryLimit < 0) {
                primaryLimit = Math.max(primaryLimit, secondaryLimit);
            } else if (MathUtils.abs(secondaryLimit) < MathUtils.abs(primaryLimit)) {
                primaryOffset += MathUtils.abs(primaryLimit + secondaryLimit);
                primaryLimit = MathUtils.abs(secondaryLimit) * sign;
            }
            Literal literal = new Literal(primary.limit().source(), (Object)primaryLimit, DataTypes.INTEGER);
            return new LimitWithOffset(primary.source(), (Expression)literal, primaryOffset, primary.child());
        }
    }

    static class PropagateJoinKeyConstraints
    extends OptimizerRules.OptimizerRule<Join> {
        PropagateJoinKeyConstraints() {
        }

        protected LogicalPlan rule(Join join) {
            ArrayList constraints = new ArrayList();
            join.queries().forEach(k -> k.forEachDown(Filter.class, f -> constraints.addAll(this.detectKeyConstraints(f.condition(), (KeyedFilter)((Object)k)))));
            if (!constraints.isEmpty()) {
                List<KeyedFilter> queries = join.queries().stream().map(k -> this.addConstraint((KeyedFilter)((Object)k), constraints)).collect(Collectors.toList());
                join = join.with(queries, join.until(), join.direction());
            }
            return join;
        }

        private List<Constraint> detectKeyConstraints(Expression condition, KeyedFilter filter) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            List<? extends NamedExpression> keys = filter.keys();
            List and = Predicates.splitAnd((Expression)condition);
            for (Expression exp : and) {
                if (exp.anyMatch(Or.class::isInstance)) continue;
                exp.anyMatch(e -> {
                    for (int i = 0; i < keys.size(); ++i) {
                        Expression key = (Expression)keys.get(i);
                        if (!e.semanticEquals(key)) continue;
                        constraints.add(new Constraint(exp, filter, i));
                        return true;
                    }
                    return false;
                });
            }
            return constraints;
        }

        private KeyedFilter addConstraint(KeyedFilter k, List<Constraint> constraints) {
            Expression constraint = Predicates.combineAnd(constraints.stream().map(c -> c.constraintFor(k)).filter(Objects::nonNull).collect(Collectors.toList()));
            return constraint != null ? new KeyedFilter(k.source(), (LogicalPlan)new Filter(k.source(), k.child(), constraint), k.keys(), k.timestamp(), k.tiebreaker()) : k;
        }

        static class Constraint {
            private final Expression condition;
            private final KeyedFilter keyedFilter;
            private final int keyPosition;

            Constraint(Expression condition, KeyedFilter filter, int keyPosition) {
                this.condition = condition;
                this.keyedFilter = filter;
                this.keyPosition = keyPosition;
            }

            Expression constraintFor(KeyedFilter keyed) {
                if (keyed == this.keyedFilter) {
                    return null;
                }
                Expression localKey = (Expression)keyed.keys().get(this.keyPosition);
                Expression key = (Expression)this.keyedFilter.keys().get(this.keyPosition);
                Expression newCond = (Expression)this.condition.transformDown(e -> key.semanticEquals(e) ? localKey : e);
                return newCond;
            }

            public String toString() {
                return this.condition.toString();
            }
        }
    }

    static final class SortByLimit
    extends OptimizerRules.OptimizerRule<LimitWithOffset> {
        SortByLimit() {
        }

        protected LogicalPlan rule(LimitWithOffset limit) {
            OrderBy ob;
            LogicalPlan child;
            if (limit.limit().foldable() && (child = limit.child()) instanceof OrderBy && PushDownOrderBy.isDefaultOrderBy(ob = (OrderBy)child)) {
                int l = (Integer)limit.limit().fold();
                Order.OrderDirection direction = Integer.signum(l) > 0 ? Order.OrderDirection.ASC : Order.OrderDirection.DESC;
                ob = new OrderBy(ob.source(), ob.child(), PushDownOrderBy.changeOrderDirection(ob.order(), direction));
                limit = new LimitWithOffset(limit.source(), limit.limit(), limit.offset(), (LogicalPlan)ob);
            }
            return limit;
        }
    }

    static final class PushDownOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PushDownOrderBy() {
        }

        protected LogicalPlan rule(OrderBy orderBy) {
            LogicalPlan child;
            Object plan = orderBy;
            if (PushDownOrderBy.isDefaultOrderBy(orderBy) && (child = orderBy.child()) instanceof Join) {
                Join join = (Join)child;
                List<KeyedFilter> queries = join.queries();
                List ascendingOrders = PushDownOrderBy.changeOrderDirection(orderBy.order(), Order.OrderDirection.ASC);
                ArrayList<KeyedFilter> orderedQueries = new ArrayList<KeyedFilter>(queries.size());
                boolean baseFilter = true;
                for (KeyedFilter filter : queries) {
                    List pushedOrder = baseFilter ? orderBy.order() : ascendingOrders;
                    OrderBy order = new OrderBy(filter.source(), filter.child(), pushedOrder);
                    orderedQueries.add(filter.replaceChild((LogicalPlan)order));
                    baseFilter = false;
                }
                KeyedFilter until = join.until();
                OrderBy order = new OrderBy(until.source(), until.child(), ascendingOrders);
                until = until.replaceChild((LogicalPlan)order);
                Order.OrderDirection direction = ((Order)orderBy.order().get(0)).direction();
                plan = join.with(orderedQueries, until, direction);
            }
            return plan;
        }

        private static boolean isDefaultOrderBy(OrderBy orderBy) {
            LogicalPlan child = orderBy.child();
            return child instanceof Filter || child instanceof Join;
        }

        private static List<Order> changeOrderDirection(List<Order> orders, Order.OrderDirection direction) {
            ArrayList<Order> changed = new ArrayList<Order>(orders.size());
            boolean hasChanged = false;
            for (Order order : orders) {
                if (order.direction() != direction) {
                    order = new Order(order.source(), order.child(), direction, direction == Order.OrderDirection.ASC ? Order.NullsPosition.FIRST : Order.NullsPosition.LAST);
                    hasChanged = true;
                }
                changed.add(order);
            }
            return hasChanged ? changed : orders;
        }
    }

    static class SkipEmptyFilter
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        SkipEmptyFilter() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            if (!(plan instanceof KeyedFilter) && plan.child() instanceof LocalRelation) {
                return new LocalRelation(plan.source(), plan.output(), Payload.Type.EVENT);
            }
            return plan;
        }
    }

    static class SkipEmptyJoin
    extends OptimizerRules.OptimizerRule<Join> {
        SkipEmptyJoin() {
        }

        protected LogicalPlan rule(Join plan) {
            for (KeyedFilter filter : plan.queries()) {
                if (!filter.anyMatch(LocalRelation.class::isInstance)) continue;
                return new LocalRelation(plan.source(), plan.output(), Payload.Type.SEQUENCE);
            }
            return plan;
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return Optimizer.skipPlan((UnaryPlan)limit);
        }
    }
}

