/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ShutdownPersistentTasksStatus;
import org.elasticsearch.cluster.metadata.ShutdownPluginsStatus;
import org.elasticsearch.cluster.metadata.ShutdownShardMigrationStatus;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.shutdown.PluginShutdownService;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.SingleNodeShutdownStatus;

public class TransportGetShutdownStatusAction
extends TransportMasterNodeAction<GetShutdownStatusAction.Request, GetShutdownStatusAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetShutdownStatusAction.class);
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final PluginShutdownService pluginShutdownService;

    @Inject
    public TransportGetShutdownStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, AllocationDeciders allocationDeciders, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, PluginShutdownService pluginShutdownService) {
        super("cluster:admin/shutdown/get", transportService, clusterService, threadPool, actionFilters, GetShutdownStatusAction.Request::readFrom, indexNameExpressionResolver, GetShutdownStatusAction.Response::new, "same");
        this.allocationService = allocationService;
        this.allocationDeciders = allocationDeciders;
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.pluginShutdownService = pluginShutdownService;
    }

    protected void masterOperation(GetShutdownStatusAction.Request request, ClusterState state, ActionListener<GetShutdownStatusAction.Response> listener) throws Exception {
        GetShutdownStatusAction.Response response;
        NodesShutdownMetadata nodesShutdownMetadata = (NodesShutdownMetadata)state.metadata().custom("node_shutdown");
        if (nodesShutdownMetadata == null) {
            response = new GetShutdownStatusAction.Response(new ArrayList<SingleNodeShutdownStatus>());
        } else if (request.getNodeIds().length == 0) {
            List<SingleNodeShutdownStatus> shutdownStatuses = nodesShutdownMetadata.getAllNodeMetadataMap().values().stream().map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(state, ns.getNodeId(), ns.getType(), this.allocationDeciders, this.clusterInfoService, this.snapshotsInfoService, this.allocationService), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        } else {
            new ArrayList();
            Map nodeShutdownMetadataMap = nodesShutdownMetadata.getAllNodeMetadataMap();
            List<SingleNodeShutdownStatus> shutdownStatuses = Arrays.stream(request.getNodeIds()).map(nodeShutdownMetadataMap::get).filter(Objects::nonNull).map(ns -> new SingleNodeShutdownStatus((SingleNodeShutdownMetadata)ns, TransportGetShutdownStatusAction.shardMigrationStatus(state, ns.getNodeId(), ns.getType(), this.allocationDeciders, this.clusterInfoService, this.snapshotsInfoService, this.allocationService), new ShutdownPersistentTasksStatus(), new ShutdownPluginsStatus(this.pluginShutdownService.readyToShutdown(ns.getNodeId(), ns.getType())))).collect(Collectors.toList());
            response = new GetShutdownStatusAction.Response(shutdownStatuses);
        }
        listener.onResponse((Object)response);
    }

    static ShutdownShardMigrationStatus shardMigrationStatus(ClusterState currentState, String nodeId, SingleNodeShutdownMetadata.Type shutdownType, AllocationDeciders allocationDeciders, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationService allocationService) {
        if (SingleNodeShutdownMetadata.Type.RESTART.equals((Object)shutdownType)) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.COMPLETE, 0L, "no shard relocation is necessary for a node restart");
        }
        if (currentState.getRoutingNodes().node(nodeId) == null) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.NOT_STARTED, 0L, "node is not currently part of the cluster");
        }
        int startedShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED});
        int relocatingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.RELOCATING});
        int initializingShards = currentState.getRoutingNodes().node(nodeId).numberOfShardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
        int totalRemainingShards = relocatingShards + startedShards + initializingShards;
        if (relocatingShards > 0 || totalRemainingShards == 0) {
            SingleNodeShutdownMetadata.Status shardStatus = totalRemainingShards == 0 ? SingleNodeShutdownMetadata.Status.COMPLETE : SingleNodeShutdownMetadata.Status.IN_PROGRESS;
            return new ShutdownShardMigrationStatus(shardStatus, (long)totalRemainingShards);
        }
        if (initializingShards > 0 && relocatingShards == 0 && startedShards == 0) {
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)totalRemainingShards, "all remaining shards are currently INITIALIZING and must finish before they can be moved off this node");
        }
        RoutingAllocation allocation = new RoutingAllocation(allocationDeciders, currentState.getRoutingNodes(), currentState, clusterInfoService.getClusterInfo(), snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        Optional<ShardRouting> unmovableShard = currentState.getRoutingNodes().node(nodeId).shardsWithState(new ShardRoutingState[]{ShardRoutingState.STARTED}).stream().map(shardRouting -> new Tuple(shardRouting, (Object)allocationService.explainShardAllocation(shardRouting, allocation))).filter(pair -> {
            assert (!((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain()) : "shard [" + pair + "] can remain on node [" + nodeId + "], but that node is shutting down";
            return !((ShardAllocationDecision)pair.v2()).getMoveDecision().canRemain();
        }).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.THROTTLED)).filter(pair -> !((ShardAllocationDecision)pair.v2()).getMoveDecision().getAllocationDecision().equals((Object)AllocationDecision.YES)).peek(pair -> {
            if (logger.isTraceEnabled()) {
                logger.trace("node [{}] shutdown of type [{}] stalled: found shard [{}][{}] from index [{}] with negative decision: [{}]", (Object)nodeId, (Object)shutdownType, (Object)((ShardRouting)pair.v1()).getId(), (Object)(((ShardRouting)pair.v1()).primary() ? "primary" : "replica"), (Object)((ShardRouting)pair.v1()).shardId().getIndexName(), (Object)Strings.toString((ToXContent)((ToXContent)pair.v2())));
            }
        }).map(Tuple::v1).findFirst();
        if (unmovableShard.isPresent()) {
            ShardRouting shardRouting2 = unmovableShard.get();
            return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.STALLED, (long)totalRemainingShards, new ParameterizedMessage("shard [{}] [{}] of index [{}] cannot move, use the Cluster Allocation Explain API on this shard for details", new Object[]{shardRouting2.shardId().getId(), shardRouting2.primary() ? "primary" : "replica", shardRouting2.index().getName()}).getFormattedMessage());
        }
        return new ShutdownShardMigrationStatus(SingleNodeShutdownMetadata.Status.IN_PROGRESS, (long)totalRemainingShards);
    }

    protected ClusterBlockException checkBlock(GetShutdownStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

