/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.shutdown.DeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.RestPutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.TransportPutShutdownNodeAction;

public class ShutdownPlugin
extends Plugin
implements ActionPlugin {
    public static final String SHUTDOWN_FEATURE_ENABLED_FLAG = "es.shutdown_feature_flag_enabled";
    public static final Setting<Boolean> SHUTDOWN_FEATURE_ENABLED_FLAG_SETTING = Setting.boolSetting((String)"es.shutdown_feature_flag_enabled", (boolean)false, enabled -> {
        if (enabled != null && enabled.booleanValue() && !Build.CURRENT.isSnapshot()) {
            throw new IllegalArgumentException("shutdown plugin may not be enabled on a non-snapshot build");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public boolean isEnabled(Settings settings) {
        return (Boolean)SHUTDOWN_FEATURE_ENABLED_FLAG_SETTING.get(settings);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler putShutdown = new ActionPlugin.ActionHandler((ActionType)PutShutdownNodeAction.INSTANCE, TransportPutShutdownNodeAction.class, new Class[0]);
        ActionPlugin.ActionHandler deleteShutdown = new ActionPlugin.ActionHandler((ActionType)DeleteShutdownNodeAction.INSTANCE, TransportDeleteShutdownNodeAction.class, new Class[0]);
        ActionPlugin.ActionHandler getStatus = new ActionPlugin.ActionHandler((ActionType)GetShutdownStatusAction.INSTANCE, TransportGetShutdownStatusAction.class, new Class[0]);
        return Arrays.asList(putShutdown, deleteShutdown, getStatus);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.isEnabled(settings)) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutShutdownNodeAction(), new RestDeleteShutdownNodeAction(), new RestGetShutdownStatusAction()});
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(SHUTDOWN_FEATURE_ENABLED_FLAG_SETTING);
    }
}

