/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.dataframe;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RestExplainDataFrameAnalyticsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object[])new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, "/_ml/data_frame/analytics/_explain"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/_explain"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/data_frame/analytics/{" + DataFrameAnalyticsConfig.ID + "}/_explain"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/{" + DataFrameAnalyticsConfig.ID + "}/_explain")});
    }

    public String getName() {
        return "ml_explain_data_frame_analytics_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId) && !restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide a job [{}] or the config object", (Object[])new Object[]{DataFrameAnalyticsConfig.ID.getPreferredName()});
        }
        if (!Strings.isNullOrEmpty((String)jobId) && restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide either a job [{}] or the config object but not both", (Object[])new Object[]{DataFrameAnalyticsConfig.ID.getPreferredName()});
        }
        PutDataFrameAnalyticsAction.Request explainRequestFromBody = Strings.isNullOrEmpty((String)jobId) ? PutDataFrameAnalyticsAction.Request.parseRequestForExplain((XContentParser)restRequest.contentOrSourceParamParser()) : null;
        return channel -> {
            RestToXContentListener listener = new RestToXContentListener(channel);
            if (explainRequestFromBody != null) {
                client.execute((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, (ActionRequest)explainRequestFromBody, (ActionListener)listener);
            } else {
                GetDataFrameAnalyticsAction.Request getRequest = new GetDataFrameAnalyticsAction.Request(jobId);
                getRequest.setAllowNoResources(false);
                client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getRequest, ActionListener.wrap(getResponse -> {
                    List jobs = getResponse.getResources().results();
                    if (jobs.size() > 1) {
                        listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"expected only one config but matched {}", (Object[])new Object[]{jobs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList())})));
                    } else {
                        PutDataFrameAnalyticsAction.Request explainRequest = new PutDataFrameAnalyticsAction.Request((DataFrameAnalyticsConfig)jobs.get(0));
                        client.execute((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)listener);
                    }
                }, arg_0 -> ((RestToXContentListener)listener).onFailure(arg_0)));
            }
        };
    }
}

