/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.task;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class JobTask
extends AllocatedPersistentTask
implements OpenJobAction.JobTaskMatcher {
    private static final Logger LOGGER = LogManager.getLogger(JobTask.class);
    private final String jobId;
    private volatile AutodetectProcessManager autodetectProcessManager;
    private volatile boolean isClosing = false;

    JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers) {
        super(id, type, action, "job-" + jobId, parentTask, headers);
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    protected void onCancelled() {
        String reason = this.getReasonCancelled();
        LOGGER.trace(() -> new ParameterizedMessage("[{}] Cancelling job task because: {}", (Object)this.jobId, (Object)reason));
        this.isClosing = true;
        this.autodetectProcessManager.killProcess(this, false, reason);
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public void closeJob(String reason) {
        this.isClosing = true;
        this.autodetectProcessManager.closeJob(this, reason);
    }

    public void killJob(String reason) {
        this.isClosing = true;
        this.autodetectProcessManager.killProcess(this, true, reason);
    }

    void setAutodetectProcessManager(AutodetectProcessManager autodetectProcessManager) {
        this.autodetectProcessManager = autodetectProcessManager;
    }
}

