/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalLong;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.NodeLoad;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class NodeLoadDetector {
    private final MlMemoryTracker mlMemoryTracker;

    public NodeLoadDetector(MlMemoryTracker memoryTracker) {
        this.mlMemoryTracker = memoryTracker;
    }

    public MlMemoryTracker getMlMemoryTracker() {
        return this.mlMemoryTracker;
    }

    public NodeLoad detectNodeLoad(ClusterState clusterState, boolean allNodesHaveDynamicMaxWorkers, DiscoveryNode node, int dynamicMaxOpenJobs, int maxMachineMemoryPercent, boolean useAutoMachineMemoryCalculation) {
        OptionalLong maxMlMemory;
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        Map nodeAttributes = node.getAttributes();
        ArrayList<String> errors = new ArrayList<String>();
        int maxNumberOfOpenJobs = dynamicMaxOpenJobs;
        if (!allNodesHaveDynamicMaxWorkers) {
            String maxNumberOfOpenJobsStr = (String)nodeAttributes.get("ml.max_open_jobs");
            try {
                maxNumberOfOpenJobs = Integer.parseInt(maxNumberOfOpenJobsStr);
            }
            catch (NumberFormatException e) {
                errors.add("ml.max_open_jobs attribute [" + maxNumberOfOpenJobsStr + "] is not an integer");
                maxNumberOfOpenJobs = -1;
            }
        }
        if (!(maxMlMemory = NativeMemoryCalculator.allowedBytesForMl(node, maxMachineMemoryPercent, useAutoMachineMemoryCalculation)).isPresent()) {
            errors.add("ml.machine_memory attribute [" + (String)nodeAttributes.get("ml.machine_memory") + "] is not a long");
        }
        NodeLoad.Builder nodeLoad = NodeLoad.builder(node.getId()).setMaxMemory(maxMlMemory.orElse(-1L)).setMaxJobs(maxNumberOfOpenJobs).setUseMemory(true);
        if (!errors.isEmpty()) {
            return nodeLoad.setError(Strings.collectionToCommaDelimitedString(errors)).build();
        }
        this.updateLoadGivenTasks(nodeLoad, persistentTasks);
        return nodeLoad.build();
    }

    private void updateLoadGivenTasks(NodeLoad.Builder nodeLoad, PersistentTasksCustomMetadata persistentTasks) {
        if (persistentTasks != null) {
            OpenJobAction.JobParams params;
            Collection assignedAnomalyDetectorTasks = persistentTasks.findTasks("xpack/ml/job", task -> nodeLoad.getNodeId().equals(task.getExecutorNode()));
            for (Object assignedTask : assignedAnomalyDetectorTasks) {
                JobState jobState = MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetadata.PersistentTask)assignedTask);
                params = (OpenJobAction.JobParams)assignedTask.getParams();
                nodeLoad.adjustForAnomalyJob(jobState, params == null ? null : params.getJobId(), this.mlMemoryTracker);
            }
            Collection assignedShapshotUpgraderTasks = persistentTasks.findTasks("xpack/ml/job/snapshot/upgrade", task -> nodeLoad.getNodeId().equals(task.getExecutorNode()));
            for (PersistentTasksCustomMetadata.PersistentTask assignedTask : assignedShapshotUpgraderTasks) {
                params = (SnapshotUpgradeTaskParams)assignedTask.getParams();
                nodeLoad.adjustForAnomalyJob(JobState.OPENED, params == null ? null : params.getJobId(), this.mlMemoryTracker);
            }
            Collection assignedAnalyticsTasks = persistentTasks.findTasks("xpack/ml/data_frame/analytics", task -> nodeLoad.getNodeId().equals(task.getExecutorNode()));
            for (PersistentTasksCustomMetadata.PersistentTask assignedTask : assignedAnalyticsTasks) {
                nodeLoad.adjustForAnalyticsJob(assignedTask, this.mlMemoryTracker);
            }
            if (nodeLoad.getNumAssignedJobs() > 0L) {
                nodeLoad.incAssignedJobMemory(MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes());
            }
        }
    }
}

