/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class NodeLoad {
    private static final Logger logger = LogManager.getLogger(NodeLoadDetector.class);
    private final long maxMemory;
    private final int maxJobs;
    private final String nodeId;
    private final boolean useMemory;
    private final String error;
    private final long numAssignedJobs;
    private final long assignedJobMemory;
    private final long numAllocatingJobs;

    public static boolean taskStateFilter(JobState jobState) {
        return jobState == null || jobState.isNoneOf(new JobState[]{JobState.CLOSED, JobState.FAILED});
    }

    public static boolean taskStateFilter(DataFrameAnalyticsState dataFrameAnalyticsState) {
        return dataFrameAnalyticsState == null || dataFrameAnalyticsState.isNoneOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPED, DataFrameAnalyticsState.FAILED});
    }

    NodeLoad(long maxMemory, int maxJobs, String nodeId, boolean useMemory, String error, long numAssignedJobs, long assignedJobMemory, long numAllocatingJobs) {
        this.maxMemory = maxMemory;
        this.maxJobs = maxJobs;
        this.nodeId = nodeId;
        this.useMemory = useMemory;
        this.error = error;
        this.numAssignedJobs = numAssignedJobs;
        this.assignedJobMemory = assignedJobMemory;
        this.numAllocatingJobs = numAllocatingJobs;
    }

    public long getNumAssignedJobs() {
        return this.numAssignedJobs;
    }

    public long getAssignedJobMemory() {
        return this.assignedJobMemory;
    }

    public long getMaxMlMemory() {
        return this.maxMemory;
    }

    public int getMaxJobs() {
        return this.maxJobs;
    }

    public boolean isUseMemory() {
        return this.useMemory;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getFreeMemory() {
        return Math.max(this.maxMemory - this.assignedJobMemory, 0L);
    }

    public int remainingJobs() {
        return Math.max(this.maxJobs - (int)this.numAssignedJobs, 0);
    }

    @Nullable
    public String getError() {
        return this.error;
    }

    public long getNumAllocatingJobs() {
        return this.numAllocatingJobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLoad nodeLoad = (NodeLoad)o;
        return this.maxMemory == nodeLoad.maxMemory && this.maxJobs == nodeLoad.maxJobs && this.useMemory == nodeLoad.useMemory && this.numAssignedJobs == nodeLoad.numAssignedJobs && this.assignedJobMemory == nodeLoad.assignedJobMemory && this.numAllocatingJobs == nodeLoad.numAllocatingJobs && Objects.equals(this.nodeId, nodeLoad.nodeId) && Objects.equals(this.error, nodeLoad.error);
    }

    public int hashCode() {
        return Objects.hash(this.maxMemory, this.maxJobs, this.nodeId, this.useMemory, this.error, this.numAssignedJobs, this.assignedJobMemory, this.numAllocatingJobs);
    }

    public static Builder builder(String nodeId) {
        return new Builder(nodeId);
    }

    public static Builder builder(NodeLoad nodeLoad) {
        return new Builder(nodeLoad);
    }

    public static class Builder {
        private long maxMemory;
        private int maxJobs;
        private final String nodeId;
        private boolean useMemory;
        private String error;
        private long numAssignedJobs;
        private long assignedJobMemory;
        private long numAllocatingJobs;

        public Builder(NodeLoad nodeLoad) {
            this.maxMemory = nodeLoad.maxMemory;
            this.maxJobs = nodeLoad.maxJobs;
            this.nodeId = nodeLoad.nodeId;
            this.useMemory = nodeLoad.useMemory;
            this.error = nodeLoad.error;
            this.numAssignedJobs = nodeLoad.numAssignedJobs;
            this.assignedJobMemory = nodeLoad.assignedJobMemory;
            this.numAllocatingJobs = nodeLoad.numAllocatingJobs;
        }

        public Builder(String nodeId) {
            this.nodeId = nodeId;
        }

        public long getFreeMemory() {
            return Math.max(this.maxMemory - this.assignedJobMemory, 0L);
        }

        public int remainingJobs() {
            return Math.max(this.maxJobs - (int)this.numAssignedJobs, 0);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getNumAssignedJobs() {
            return this.numAssignedJobs;
        }

        public Builder setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public Builder setMaxJobs(int maxJobs) {
            this.maxJobs = maxJobs;
            return this;
        }

        public Builder setUseMemory(boolean useMemory) {
            this.useMemory = useMemory;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder incNumAssignedJobs() {
            ++this.numAssignedJobs;
            return this;
        }

        public Builder incAssignedJobMemory(long assignedJobMemory) {
            this.assignedJobMemory += assignedJobMemory;
            return this;
        }

        public Builder incNumAllocatingJobs() {
            ++this.numAllocatingJobs;
            return this;
        }

        void adjustForAnomalyJob(JobState jobState, String jobId, MlMemoryTracker mlMemoryTracker) {
            if (NodeLoad.taskStateFilter(jobState) && jobId != null) {
                Long jobMemoryRequirement;
                ++this.numAssignedJobs;
                if (jobState == JobState.OPENING) {
                    ++this.numAllocatingJobs;
                }
                if ((jobMemoryRequirement = mlMemoryTracker.getAnomalyDetectorJobMemoryRequirement(jobId)) == null) {
                    this.useMemory = false;
                    logger.debug(() -> new ParameterizedMessage("[{}] memory requirement was not available. Calculating load by number of assigned jobs.", (Object)jobId));
                } else {
                    this.assignedJobMemory += jobMemoryRequirement.longValue();
                }
            }
        }

        void adjustForAnalyticsJob(PersistentTasksCustomMetadata.PersistentTask<?> assignedTask, MlMemoryTracker mlMemoryTracker) {
            DataFrameAnalyticsState dataFrameAnalyticsState = MlTasks.getDataFrameAnalyticsState(assignedTask);
            if (NodeLoad.taskStateFilter(dataFrameAnalyticsState)) {
                ++this.numAssignedJobs;
                StartDataFrameAnalyticsAction.TaskParams params = (StartDataFrameAnalyticsAction.TaskParams)assignedTask.getParams();
                Long jobMemoryRequirement = mlMemoryTracker.getDataFrameAnalyticsJobMemoryRequirement(params.getId());
                if (jobMemoryRequirement == null) {
                    this.useMemory = false;
                    logger.debug(() -> new ParameterizedMessage("[{}] memory requirement was not available. Calculating load by number of assigned jobs.", (Object)params.getId()));
                } else {
                    this.assignedJobMemory += jobMemoryRequirement.longValue();
                }
            }
        }

        public NodeLoad build() {
            return new NodeLoad(this.maxMemory, this.maxJobs, this.nodeId, this.useMemory, this.error, this.numAssignedJobs, this.assignedJobMemory, this.numAllocatingJobs);
        }
    }
}

