/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportDeleteJobAction
extends AcknowledgedTransportMasterNodeAction<DeleteJobAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteJobAction.class);
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final AnomalyDetectionAuditor auditor;
    private final JobConfigProvider jobConfigProvider;
    private final JobManager jobManager;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final Map<String, List<ActionListener<AcknowledgedResponse>>> listenersByJobId;

    @Inject
    public TransportDeleteJobAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, Client client, AnomalyDetectionAuditor auditor, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, MlMemoryTracker memoryTracker, JobManager jobManager) {
        super("cluster:admin/xpack/ml/job/delete", transportService, clusterService, threadPool, actionFilters, DeleteJobAction.Request::new, indexNameExpressionResolver, "same");
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.auditor = auditor;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.listenersByJobId = new HashMap<String, List<ActionListener<AcknowledgedResponse>>>();
        this.jobManager = jobManager;
    }

    protected ClusterBlockException checkBlock(DeleteJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        throw new UnsupportedOperationException("the Task parameter is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void masterOperation(Task task, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobId(), state)) {
            listener.onFailure((Exception)ExceptionsHelper.configHasNotBeenMigrated((String)"delete job", (String)request.getJobId()));
            return;
        }
        logger.debug(() -> new ParameterizedMessage("[{}] deleting job ", (Object)request.getJobId()));
        if (!request.isForce()) {
            this.checkJobIsNotOpen(request.getJobId(), state);
        }
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            if (this.listenersByJobId.containsKey(request.getJobId())) {
                logger.debug(() -> new ParameterizedMessage("[{}] Deletion task [{}] will wait for existing deletion task to complete", (Object)request.getJobId(), (Object)task.getId()));
                this.listenersByJobId.get(request.getJobId()).add(listener);
                return;
            }
            ArrayList<ActionListener<AcknowledgedResponse>> listeners = new ArrayList<ActionListener<AcknowledgedResponse>>();
            listeners.add(listener);
            this.listenersByJobId.put(request.getJobId(), listeners);
        }
        ActionListener finalListener = ActionListener.wrap(ack -> this.notifyListeners(request.getJobId(), (AcknowledgedResponse)ack, null), e -> {
            this.notifyListeners(request.getJobId(), null, (Exception)e);
            if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                this.auditor.error(request.getJobId(), Messages.getMessage((String)"Error deleting job: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        });
        ActionListener markAsDeletingListener = ActionListener.wrap(response -> {
            if (request.isForce()) {
                this.forceDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                this.normalDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)finalListener);
            }
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
        ActionListener jobExistsListener = ActionListener.wrap(response -> {
            this.auditor.info(request.getJobId(), Messages.getMessage((String)"Deleting job by task with id ''{0}''", (Object[])new Object[]{taskId}));
            this.markJobAsDeletingIfNotUsed(request.getJobId(), taskId, (ActionListener<PutJobAction.Response>)markAsDeletingListener);
        }, e -> {
            if (request.isForce() && MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetadata)((PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks"))) != null) {
                logger.info("[{}] config is missing but task exists. Attempting to delete tasks and stop process", (Object)request.getJobId());
                this.forceDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                finalListener.onFailure(e);
            }
        });
        this.jobConfigProvider.jobExists(request.getJobId(), true, (ActionListener<Boolean>)jobExistsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String jobId, @Nullable AcknowledgedResponse ack, @Nullable Exception error) {
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            List<ActionListener<AcknowledgedResponse>> listeners = this.listenersByJobId.remove(jobId);
            if (listeners == null) {
                logger.error("[{}] No deletion job listeners could be found", (Object)jobId);
                return;
            }
            for (ActionListener<AcknowledgedResponse> listener : listeners) {
                if (error != null) {
                    listener.onFailure(error);
                    continue;
                }
                listener.onResponse((Object)ack);
            }
        }
    }

    private void normalDeleteJob(ParentTaskAssigningClient parentTaskClient, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        this.memoryTracker.removeAnomalyDetectorJob(jobId);
        this.jobManager.deleteJob(request, (Client)parentTaskClient, state, listener);
    }

    private void forceDeleteJob(final ParentTaskAssigningClient parentTaskClient, final DeleteJobAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        logger.debug(() -> new ParameterizedMessage("[{}] force deleting job", (Object)jobId));
        ActionListener<Boolean> removeTaskListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, TransportDeleteJobAction.this.clusterService.state(), (ActionListener<AcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, TransportDeleteJobAction.this.clusterService.state(), (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    listener.onFailure(e);
                }
            }
        };
        ActionListener killJobListener = ActionListener.wrap(arg_0 -> this.lambda$forceDeleteJob$8(jobId, state, (ActionListener)removeTaskListener, arg_0), arg_0 -> this.lambda$forceDeleteJob$9(jobId, state, (ActionListener)removeTaskListener, listener, arg_0));
        this.killProcess(parentTaskClient, jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
    }

    private void killProcess(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<KillProcessAction.Response> listener) {
        KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)KillProcessAction.INSTANCE, (ActionRequest)killRequest, listener);
    }

    private void removePersistentTask(String jobId, ClusterState currentState, ActionListener<Boolean> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask == null) {
            listener.onResponse(null);
        } else {
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), listener.delegateFailure((l, task) -> l.onResponse((Object)Boolean.TRUE)));
        }
    }

    private void checkJobIsNotOpen(String jobId, ClusterState state) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask != null) {
            JobTaskState jobTaskState = (JobTaskState)jobTask.getState();
            throw ExceptionsHelper.conflictStatusException((String)("Cannot delete job [" + jobId + "] because the job is " + (jobTaskState == null ? JobState.OPENING : jobTaskState.getState())), (Object[])new Object[0]);
        }
    }

    private void markJobAsDeletingIfNotUsed(String jobId, TaskId taskId, ActionListener<PutJobAction.Response> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (!datafeedIds.isEmpty()) {
                listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("Cannot delete job [" + jobId + "] because datafeed [" + (String)datafeedIds.iterator().next() + "] refers to it"), (Object[])new Object[0]));
                return;
            }
            this.cancelResetTaskIfExists(jobId, (ActionListener<Boolean>)ActionListener.wrap(response -> this.jobConfigProvider.updateJobBlockReason(jobId, new Blocked(Blocked.Reason.DELETE, taskId), listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void cancelResetTaskIfExists(String jobId, ActionListener<Boolean> listener) {
        ActionListener jobListener = ActionListener.wrap(jobBuilder -> {
            Job job = jobBuilder.build();
            if (job.getBlocked().getReason() == Blocked.Reason.RESET) {
                logger.info("[{}] Cancelling reset task [{}] because delete was requested", (Object)jobId, (Object)job.getBlocked().getTaskId());
                CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
                cancelTasksRequest.setReason("deleting job");
                cancelTasksRequest.setActions(new String[]{"cluster:admin/xpack/ml/job/reset"});
                cancelTasksRequest.setTaskId(job.getBlocked().getTaskId());
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)CancelTasksAction.INSTANCE, (ActionRequest)cancelTasksRequest, (ActionListener)ActionListener.wrap(cancelTasksResponse -> listener.onResponse((Object)true), e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(e);
                    }
                }));
            } else {
                listener.onResponse((Object)false);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.getJob(jobId, (ActionListener<Job.Builder>)jobListener);
    }

    private /* synthetic */ void lambda$forceDeleteJob$9(String jobId, ClusterState state, ActionListener removeTaskListener, ActionListener listener, Exception e) {
        if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ElasticsearchStatusException) {
            this.removePersistentTask(jobId, state, (ActionListener<Boolean>)removeTaskListener);
        } else {
            listener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$forceDeleteJob$8(String jobId, ClusterState state, ActionListener removeTaskListener, KillProcessAction.Response response) throws Exception {
        this.removePersistentTask(jobId, state, (ActionListener<Boolean>)removeTaskListener);
    }
}

