/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenResponse;
import org.elasticsearch.xpack.security.authc.service.IndexServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.support.HttpTlsRuntimeCheck;

public class TransportDeleteServiceAccountTokenAction
extends HandledTransportAction<DeleteServiceAccountTokenRequest, DeleteServiceAccountTokenResponse> {
    private final IndexServiceAccountTokenStore indexServiceAccountTokenStore;
    private final HttpTlsRuntimeCheck httpTlsRuntimeCheck;

    @Inject
    public TransportDeleteServiceAccountTokenAction(TransportService transportService, ActionFilters actionFilters, IndexServiceAccountTokenStore indexServiceAccountTokenStore, HttpTlsRuntimeCheck httpTlsRuntimeCheck) {
        super("cluster:admin/xpack/security/service_account/token/delete", transportService, actionFilters, DeleteServiceAccountTokenRequest::new);
        this.indexServiceAccountTokenStore = indexServiceAccountTokenStore;
        this.httpTlsRuntimeCheck = httpTlsRuntimeCheck;
    }

    protected void doExecute(Task task, DeleteServiceAccountTokenRequest request, ActionListener<DeleteServiceAccountTokenResponse> listener) {
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "delete service account token", () -> this.indexServiceAccountTokenStore.deleteToken(request, (ActionListener<Boolean>)ActionListener.wrap(found -> listener.onResponse((Object)new DeleteServiceAccountTokenResponse(found.booleanValue())), arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
    }
}

