/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.service.IndexServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.support.HttpTlsRuntimeCheck;

public class TransportCreateServiceAccountTokenAction
extends HandledTransportAction<CreateServiceAccountTokenRequest, CreateServiceAccountTokenResponse> {
    private final IndexServiceAccountTokenStore indexServiceAccountTokenStore;
    private final SecurityContext securityContext;
    private final HttpTlsRuntimeCheck httpTlsRuntimeCheck;

    @Inject
    public TransportCreateServiceAccountTokenAction(TransportService transportService, ActionFilters actionFilters, IndexServiceAccountTokenStore indexServiceAccountTokenStore, SecurityContext securityContext, HttpTlsRuntimeCheck httpTlsRuntimeCheck) {
        super("cluster:admin/xpack/security/service_account/token/create", transportService, actionFilters, CreateServiceAccountTokenRequest::new);
        this.indexServiceAccountTokenStore = indexServiceAccountTokenStore;
        this.securityContext = securityContext;
        this.httpTlsRuntimeCheck = httpTlsRuntimeCheck;
    }

    protected void doExecute(Task task, CreateServiceAccountTokenRequest request, ActionListener<CreateServiceAccountTokenResponse> listener) {
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "create service account token", () -> {
            Authentication authentication = this.securityContext.getAuthentication();
            if (authentication == null) {
                listener.onFailure((Exception)new IllegalStateException("authentication is required"));
            } else {
                this.indexServiceAccountTokenStore.createToken(authentication, request, listener);
            }
        });
    }
}

