/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.sql.action.SqlQueryTask;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public class SqlConfiguration
extends Configuration {
    private final int pageSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Mode mode;
    private final String clientId;
    private final SqlVersion version;
    private final boolean multiValueFieldLeniency;
    private final boolean includeFrozenIndices;
    private final TimeValue waitForCompletionTimeout;
    private final boolean keepOnCompletion;
    private final TimeValue keepAlive;
    @Nullable
    private final TaskId taskId;
    @Nullable
    private final SqlQueryTask task;
    @Nullable
    private QueryBuilder filter;
    @Nullable
    private Map<String, Object> runtimeMappings;

    public SqlConfiguration(ZoneId zi, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Map<String, Object> runtimeMappings, Mode mode, String clientId, SqlVersion version, String username, String clusterName, boolean multiValueFieldLeniency, boolean includeFrozen, @Nullable TaskId taskId, @Nullable SqlQueryTask task, TimeValue waitForCompletionTimeout, boolean keepOnCompletion, TimeValue keepAlive) {
        super(zi, username, clusterName, x -> Collections.emptySet());
        this.pageSize = pageSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.runtimeMappings = runtimeMappings;
        this.mode = mode == null ? Mode.PLAIN : mode;
        this.clientId = clientId;
        this.version = version != null ? version : SqlVersion.fromId((int)Version.CURRENT.id);
        this.multiValueFieldLeniency = multiValueFieldLeniency;
        this.includeFrozenIndices = includeFrozen;
        this.taskId = taskId;
        this.task = task;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        this.keepOnCompletion = keepOnCompletion;
        this.keepAlive = keepAlive;
    }

    public SqlConfiguration(ZoneId zi, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Map<String, Object> runtimeMappings, Mode mode, String clientId, SqlVersion version, String username, String clusterName, boolean multiValueFieldLeniency, boolean includeFrozen) {
        this(zi, pageSize, requestTimeout, pageTimeout, filter, runtimeMappings, mode, clientId, version, username, clusterName, multiValueFieldLeniency, includeFrozen, null, null, Protocol.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT, Protocol.DEFAULT_KEEP_ON_COMPLETION, Protocol.DEFAULT_KEEP_ALIVE);
    }

    public int pageSize() {
        return this.pageSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public Mode mode() {
        return this.mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public boolean multiValueFieldLeniency() {
        return this.multiValueFieldLeniency;
    }

    public boolean includeFrozen() {
        return this.includeFrozenIndices;
    }

    public SqlVersion version() {
        return this.version;
    }

    public TaskId taskId() {
        return this.taskId;
    }

    public SqlQueryTask task() {
        return this.task;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }
}

