/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.plan.logical.Distinct;
import org.elasticsearch.xpack.sql.plan.logical.Having;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.With;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.session.SingletonExecutable;

abstract class LogicalPlanBuilder
extends ExpressionBuilder {
    protected LogicalPlanBuilder(Map<Token, SqlTypedParamValue> params, ZoneId zoneId) {
        super(params, zoneId);
    }

    @Override
    public LogicalPlan visitQuery(SqlBaseParser.QueryContext ctx) {
        LogicalPlan body = this.plan((ParseTree)ctx.queryNoWith());
        List<SubQueryAlias> namedQueries = this.visitList(ctx.namedQuery(), SubQueryAlias.class);
        LinkedHashMap<String, SubQueryAlias> cteRelations = new LinkedHashMap<String, SubQueryAlias>(namedQueries.size());
        for (SubQueryAlias namedQuery : namedQueries) {
            if (cteRelations.put(namedQuery.alias(), namedQuery) == null) continue;
            throw new ParsingException(namedQuery.source(), "Duplicate alias {}", namedQuery.alias());
        }
        return new With(LogicalPlanBuilder.source(ctx), body, cteRelations);
    }

    @Override
    public LogicalPlan visitNamedQuery(SqlBaseParser.NamedQueryContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.queryNoWith()), ctx.name.getText());
    }

    @Override
    public LogicalPlan visitQueryNoWith(SqlBaseParser.QueryNoWithContext ctx) {
        Token limit;
        SqlBaseParser.LimitClauseContext limitClause;
        LogicalPlan plan = this.plan((ParseTree)ctx.queryTerm());
        if (!ctx.orderBy().isEmpty()) {
            List<SqlBaseParser.OrderByContext> orders = ctx.orderBy();
            SqlBaseParser.OrderByContext endContext = orders.get(orders.size() - 1);
            Source source = LogicalPlanBuilder.source(ctx.ORDER(), endContext);
            List<Order> order = this.visitList(ctx.orderBy(), Order.class);
            if (plan instanceof Limit) {
                Limit limit2 = (Limit)plan;
                plan = limit2.replaceChild((LogicalPlan)new OrderBy(source, limit2.child(), order));
            } else {
                plan = new OrderBy(source, plan, order);
            }
        }
        if ((limitClause = ctx.limitClause()) != null && (limit = limitClause.limit) != null && limitClause.INTEGER_VALUE() != null) {
            if (plan instanceof Limit) {
                throw new ParsingException(LogicalPlanBuilder.source(limitClause), "TOP and LIMIT are not allowed in the same query - use one or the other", new Object[0]);
            }
            plan = this.limit(plan, LogicalPlanBuilder.source(limitClause), limit);
        }
        return plan;
    }

    @Override
    public LogicalPlan visitQuerySpecification(SqlBaseParser.QuerySpecificationContext ctx) {
        SqlBaseParser.TopClauseContext topClauseContext;
        Object query = ctx.fromClause() == null ? new LocalRelation(LogicalPlanBuilder.source(ctx), new SingletonExecutable()) : this.plan((ParseTree)ctx.fromClause());
        if (ctx.where != null) {
            query = new Filter(LogicalPlanBuilder.source(ctx), query, this.expression((ParseTree)ctx.where));
        }
        List selectTarget = ctx.selectItems().isEmpty() ? Collections.emptyList() : this.visitList(ctx.selectItems().selectItem(), NamedExpression.class);
        SqlBaseParser.GroupByContext groupByCtx = ctx.groupBy();
        if (groupByCtx != null) {
            TerminalNode groupByAll;
            SqlBaseParser.SetQuantifierContext setQualifierContext = groupByCtx.setQuantifier();
            TerminalNode terminalNode = groupByAll = setQualifierContext == null ? null : setQualifierContext.ALL();
            if (groupByAll != null) {
                throw new ParsingException(LogicalPlanBuilder.source(groupByAll), "GROUP BY ALL is not supported", new Object[0]);
            }
            List<SqlBaseParser.GroupingElementContext> groupingElement = groupByCtx.groupingElement();
            List<Expression> groupBy = this.expressions(groupingElement);
            SqlBaseParser.GroupByContext endSource = groupingElement.isEmpty() ? groupByCtx : (ParserRuleContext)groupingElement.get(groupingElement.size() - 1);
            query = new Aggregate(LogicalPlanBuilder.source(ctx.GROUP(), endSource), query, groupBy, selectTarget);
        } else if (!selectTarget.isEmpty()) {
            query = new Project(LogicalPlanBuilder.source(ctx.selectItems()), query, selectTarget);
        }
        if (ctx.having != null) {
            query = new Having(LogicalPlanBuilder.source(ctx.having), (LogicalPlan)query, this.expression((ParseTree)ctx.having));
        }
        if (ctx.setQuantifier() != null && ctx.setQuantifier().DISTINCT() != null) {
            query = new Distinct(LogicalPlanBuilder.source(ctx.setQuantifier()), (LogicalPlan)query);
        }
        if ((topClauseContext = ctx.topClause()) != null && topClauseContext.top != null && topClauseContext.INTEGER_VALUE() != null) {
            query = this.limit((LogicalPlan)query, LogicalPlanBuilder.source(topClauseContext), topClauseContext.top);
        }
        return query;
    }

    @Override
    public LogicalPlan visitFromClause(SqlBaseParser.FromClauseContext ctx) {
        List<LogicalPlan> plans = this.plans(ctx.relation());
        Object plan = (LogicalPlan)plans.stream().reduce((left, right) -> new Join(LogicalPlanBuilder.source(ctx), (LogicalPlan)left, (LogicalPlan)right, Join.JoinType.IMPLICIT, null)).get();
        if (ctx.pivotClause() != null) {
            SqlBaseParser.PivotClauseContext pivotClause = ctx.pivotClause();
            UnresolvedAttribute column = new UnresolvedAttribute(LogicalPlanBuilder.source(pivotClause.column), this.visitQualifiedName(pivotClause.column));
            List<NamedExpression> values = this.namedValues(pivotClause.aggs);
            if (values.size() > 1) {
                throw new ParsingException(LogicalPlanBuilder.source(pivotClause.aggs), "PIVOT currently supports only one aggregation, found [{}]", values.size());
            }
            plan = new Pivot(LogicalPlanBuilder.source(pivotClause), (LogicalPlan)plan, (Expression)column, this.namedValues(pivotClause.vals), this.namedValues(pivotClause.aggs));
        }
        return plan;
    }

    private List<NamedExpression> namedValues(SqlBaseParser.PivotArgsContext args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NamedExpression> values = new ArrayList<NamedExpression>();
        for (SqlBaseParser.NamedValueExpressionContext value : args.namedValueExpression()) {
            Expression exp = this.expression((ParseTree)value.valueExpression());
            String alias = this.visitIdentifier(value.identifier());
            Source source = LogicalPlanBuilder.source(value);
            values.add((NamedExpression)(alias != null ? new Alias(source, alias, exp) : new UnresolvedAlias(source, exp)));
        }
        return values;
    }

    @Override
    public LogicalPlan visitRelation(SqlBaseParser.RelationContext ctx) {
        Object result = this.plan((ParseTree)ctx.relationPrimary());
        for (SqlBaseParser.JoinRelationContext j : ctx.joinRelation()) {
            result = this.doJoin(j);
        }
        return result;
    }

    private Join doJoin(SqlBaseParser.JoinRelationContext ctx) {
        SqlBaseParser.JoinCriteriaContext criteria = ctx.joinCriteria();
        if (criteria != null && criteria.USING() != null) {
            throw new UnsupportedOperationException();
        }
        throw new ParsingException(LogicalPlanBuilder.source(ctx), "Queries with JOIN are not yet supported", new Object[0]);
    }

    @Override
    public Object visitAliasedRelation(SqlBaseParser.AliasedRelationContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.relation()), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Object visitAliasedQuery(SqlBaseParser.AliasedQueryContext ctx) {
        return new SubQueryAlias(LogicalPlanBuilder.source(ctx), this.plan((ParseTree)ctx.queryNoWith()), this.visitQualifiedName(ctx.qualifiedName()));
    }

    @Override
    public Object visitSubquery(SqlBaseParser.SubqueryContext ctx) {
        return this.plan((ParseTree)ctx.queryNoWith());
    }

    @Override
    public LogicalPlan visitTableName(SqlBaseParser.TableNameContext ctx) {
        String alias = this.visitQualifiedName(ctx.qualifiedName());
        TableIdentifier tableIdentifier = this.visitTableIdentifier(ctx.tableIdentifier());
        return new UnresolvedRelation(LogicalPlanBuilder.source(ctx), tableIdentifier, alias, ctx.FROZEN() != null);
    }

    private Limit limit(LogicalPlan plan, Source source, Token limit) {
        return new Limit(source, (Expression)new Literal(source, (Object)Integer.parseInt(limit.getText()), DataTypes.INTEGER), plan);
    }
}

