/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.util;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String NEW_LINE = "\n";
    public static final String SQL_WILDCARD = "%";
    public static final String WILDCARD = "*";
    private static final String[] INTEGER_ORDINALS = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};

    private StringUtils() {
    }

    public static String camelCaseToUnderscore(String string) {
        if (!Strings.hasText(string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim();
        boolean previousCharWasUp = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isAlphabetic(ch)) {
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && !previousCharWasUp) {
                        sb.append("_");
                    }
                    previousCharWasUp = true;
                } else {
                    previousCharWasUp = ch == '_';
                }
            } else {
                previousCharWasUp = true;
            }
            sb.append(ch);
        }
        return sb.toString().toUpperCase(Locale.ROOT);
    }

    public static String underscoreToLowerCamelCase(String string) {
        if (!Strings.hasText(string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim().toLowerCase(Locale.ROOT);
        boolean previousCharWasUnderscore = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '_') {
                previousCharWasUnderscore = true;
                continue;
            }
            if (previousCharWasUnderscore) {
                sb.append(Character.toUpperCase(ch));
                previousCharWasUnderscore = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String likeToJavaPattern(String pattern, char escape) {
        StringBuilder regex = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        regex.append('^');
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                if (i + 1 != pattern.length()) continue;
                throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
            }
            switch (curr) {
                case '%': {
                    regex.append(escaped ? SQL_WILDCARD : ".*");
                    break;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    switch (curr) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append('\\');
                        }
                    }
                    regex.append(curr);
                }
            }
            escaped = false;
        }
        regex.append('$');
        return regex.toString();
    }

    public static String likeToLuceneWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : WILDCARD);
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : "?");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    switch (curr) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            wildcard.append('\\');
                        }
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String likeToIndexWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : WILDCARD);
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : WILDCARD);
                    break;
                }
                default: {
                    if (escaped) {
                        throw new QlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String likeToUnescaped(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length());
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                continue;
            }
            if (escaped && (curr == '%' || curr == '_' || curr == escape)) {
                wildcard.append(curr);
            } else {
                if (escaped) {
                    wildcard.append(escape);
                }
                wildcard.append(curr);
            }
            escaped = false;
        }
        if (escaped) {
            wildcard.append(escape);
        }
        return wildcard.toString();
    }

    public static String toString(SearchSourceBuilder source) {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint().humanReadable(true);
        try {
            source.toXContent(builder, ToXContent.EMPTY_PARAMS);
            String string = Strings.toString(builder);
            if (builder != null) {
                builder.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (builder != null) {
                    try {
                        builder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("error rendering", e);
            }
        }
    }

    public static List<String> findSimilar(String match, Iterable<String> potentialMatches) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple<Float, String>> scoredMatches = new ArrayList<Tuple<Float, String>>();
        for (String potentialMatch : potentialMatches) {
            float distance = ld.getDistance(match, potentialMatch);
            if (!(distance >= 0.5f)) continue;
            scoredMatches.add(new Tuple<Float, String>(Float.valueOf(distance), potentialMatch));
        }
        CollectionUtil.timSort(scoredMatches, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredMatches.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    public static double parseDouble(String string) throws QlIllegalArgumentException {
        double value;
        try {
            value = Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            throw new QlIllegalArgumentException("Cannot parse number [{}]", string);
        }
        if (Double.isInfinite(value)) {
            throw new QlIllegalArgumentException("Number [{}] is too large", string);
        }
        if (Double.isNaN(value)) {
            throw new QlIllegalArgumentException("[{}] cannot be parsed as a number (NaN)", string);
        }
        return value;
    }

    public static long parseLong(String string) throws QlIllegalArgumentException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfe) {
            try {
                BigInteger bi = new BigInteger(string);
                try {
                    bi.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw new QlIllegalArgumentException("Number [{}] is too large", string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new QlIllegalArgumentException("Cannot parse number [{}]", string);
        }
    }

    public static String ordinal(int i) {
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + INTEGER_ORDINALS[i % 10];
    }
}

