/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.execution;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.transform.Transform;

public class WatchExecutionResult
implements ToXContentObject {
    private final ZonedDateTime executionTime;
    private final long executionDurationMs;
    @Nullable
    private final Input.Result inputResult;
    @Nullable
    private final Condition.Result conditionResult;
    @Nullable
    private final Transform.Result transformResult;
    private final Map<String, ActionWrapperResult> actionsResults;

    public WatchExecutionResult(WatchExecutionContext context, long executionDurationMs) {
        this(context.executionTime(), executionDurationMs, context.inputResult(), context.conditionResult(), context.transformResult(), context.actionsResults());
    }

    private WatchExecutionResult(ZonedDateTime executionTime, long executionDurationMs, Input.Result inputResult, Condition.Result conditionResult, @Nullable Transform.Result transformResult, Map<String, ActionWrapperResult> actionsResults) {
        this.executionTime = executionTime;
        this.inputResult = inputResult;
        this.conditionResult = conditionResult;
        this.transformResult = transformResult;
        this.actionsResults = actionsResults;
        this.executionDurationMs = executionDurationMs;
    }

    public ZonedDateTime executionTime() {
        return this.executionTime;
    }

    public long executionDurationMs() {
        return this.executionDurationMs;
    }

    public Input.Result inputResult() {
        return this.inputResult;
    }

    public Condition.Result conditionResult() {
        return this.conditionResult;
    }

    public Transform.Result transformResult() {
        return this.transformResult;
    }

    public Map<String, ActionWrapperResult> actionsResults() {
        return this.actionsResults;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        WatcherDateTimeUtils.writeDate(Field.EXECUTION_TIME.getPreferredName(), builder, this.executionTime);
        builder.field(Field.EXECUTION_DURATION.getPreferredName(), this.executionDurationMs);
        if (this.inputResult != null) {
            builder.field(Field.INPUT.getPreferredName(), this.inputResult, params);
        }
        if (this.conditionResult != null) {
            builder.field(Field.CONDITION.getPreferredName(), this.conditionResult, params);
        }
        if (this.transformResult != null) {
            builder.field(Transform.TRANSFORM.getPreferredName(), this.transformResult, params);
        }
        builder.startArray(Field.ACTIONS.getPreferredName());
        for (ActionWrapperResult result : this.actionsResults.values()) {
            result.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static interface Field {
        public static final ParseField EXECUTION_TIME = new ParseField("execution_time", new String[0]);
        public static final ParseField EXECUTION_DURATION = new ParseField("execution_duration", new String[0]);
        public static final ParseField INPUT = new ParseField("input", new String[0]);
        public static final ParseField CONDITION = new ParseField("condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
    }
}

