/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.common.stats;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class Counters
implements Writeable {
    private ObjectLongHashMap<String> counters = new ObjectLongHashMap();

    public Counters(StreamInput in) throws IOException {
        int counters = in.readVInt();
        for (int i = 0; i < counters; ++i) {
            this.inc(in.readString(), in.readVLong());
        }
    }

    public Counters(String ... names) {
        for (String name : names) {
            this.set(name);
        }
    }

    public void set(String name) {
        this.counters.put((Object)name, 0L);
    }

    public void inc(String name) {
        this.inc(name, 1L);
    }

    public void inc(String name, long count) {
        this.counters.addTo((Object)name, count);
    }

    public long get(String name) {
        return this.counters.get((Object)name);
    }

    public long size() {
        return this.counters.size();
    }

    public boolean hasCounters() {
        return this.size() > 0L;
    }

    public Map<String, Object> toNestedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ObjectLongCursor counter : this.counters) {
            if (((String)counter.key).contains(".")) {
                String[] parts = ((String)counter.key).split("\\.");
                Map<String, Object> curr = map;
                for (int i = 0; i < parts.length; ++i) {
                    boolean isLast;
                    String part = parts[i];
                    boolean bl = isLast = i == parts.length - 1;
                    if (!isLast) {
                        if (!curr.containsKey(part)) {
                            curr.put(part, new HashMap());
                            curr = (Map)curr.get(part);
                            continue;
                        }
                        curr = (Map)curr.get(part);
                        continue;
                    }
                    curr.put(part, counter.value);
                }
                continue;
            }
            map.put((String)counter.key, counter.value);
        }
        return map;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.counters.size());
        for (ObjectLongCursor cursor : this.counters) {
            out.writeString((String)cursor.key);
            out.writeVLong(cursor.value);
        }
    }

    public static Counters merge(List<Counters> counters) {
        Counters result = new Counters(new String[0]);
        for (Counters c : counters) {
            for (ObjectLongCursor cursor : c.counters) {
                result.inc((String)cursor.key, cursor.value);
            }
        }
        return result;
    }
}

